# zero Diverter Scriptlet for Nightmare

from mpf.system.scriptlet import Scriptlet
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timer
from mpf.system.timing import Timing
import random
import math

class ZeroDiverter(Scriptlet):

    def on_load(self):
        self.delay = DelayManager()
        self.enabled = 0
        self.machine.switch_controller.add_switch_handler(
            'rampreturnl_sw', self.open_diverter)
        self.machine.events.add_handler('zero_disable_diverter', self.disable_diverter)
        self.machine.events.add_handler('zero_enable_diverter', self.enable_diverter)

    def enable_diverter(self, **kwargs):
        self.enabled = 1

    def disable_diverter(self, **kwargs):
        self.enabled = 0

    def open_diverter(self):
        if self.enabled == 1:
            self.machine.coils['zerodiverter'].enable()
            delaytime = Timing.string_to_ms('3s')
            self.delay.add(name='zero_close_diverter', ms=delaytime, callback=self.close_diverter)
            self.log.info("Activate - Zero Diverter")
            self.enabled = 0  #one time use, needs to be reset from zero_enable_diverter event

    def close_diverter(self):
        self.machine.coils['zerodiverter'].disable()

    def disable(self):
        self.close_diverter()

