# target controller Scriptlet for Nightmare

from mpf.system.scriptlet import Scriptlet

class Targetbank(Scriptlet):

    def on_load(self):
        self.machine.switch_controller.add_switch_handler(
            'targetbankdown_sw', self.stop_moving)
        self.machine.switch_controller.add_switch_handler(
            'targetbankup_sw', self.stop_moving)

        self.machine.switch_controller.add_switch_handler(
            'subwayoogie_sw', self.move_up)

        self.machine.switch_controller.add_switch_handler(
            'oogietarget2_sw', self.move_down)
        

    def enable(self):
        self.machine.switch_controller.add_switch_handler(
            'targetbankup_sw', self.stop_moving)
        self.machine.switch_controller.add_switch_handler(
            'targetbankdown_sw', self.stop_moving, ms=100)

    def disable(self):
        self.stop_moving()
        self.machine.switch_controller.remove_switch_handler(
            'targetbankup_sw', self.stop_moving)
        self.machine.switch_controller.remove_switch_handler(
            'targetbankdown_sw', self.stop_moving)

    def move_up(self):
        if (self.machine.switch_controller.is_active('targetbankup_sw')):
            return
        self.machine.coils['targetbankmotor'].enable()

    def move_down(self):
        if (self.machine.switch_controller.is_active('targetbankdown_sw')):
            return
        self.machine.coils['targetbankmotor'].enable()

    def stop_moving(self):
        self.machine.coils['targetbankmotor'].disable()

