# soupdiverter Scriptlet for Nightmare

from mpf.system.scriptlet import Scriptlet
from mpf.system.timing import Timer
import random
import math
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing

class Soupdiverter(Scriptlet):

    def on_load(self):
        self.delay = DelayManager()
        self.systimer = Timer(callback=self.my_timer, frequency=10)
        self.machine.timing.add(self.systimer)
        self.gate_state = 0

    def my_timer(self):
        if self.gate_state == 0:
            self.log.info("Activate - Soup Gate")
            self.open()
            delaytime = Timing.string_to_ms('4s')
            self.delay.add(name='disable_soup_diverter', ms=delaytime, callback=self.close)
        else:
            self.close()
            self.log.info("Deactivate - Soup Gate")

    def disable(self):
        self.close()
        self.machine.timing.remove(self.systimer)

    def open(self):
        self.gate_state = 1
        if self.machine.game:
            self.machine.coils['soupdiverter'].enable()
            self.machine.events.post('soup_gate_open')
            colR = random.randint(0,255)
            colG = random.randint(0,255)
            colB = random.randint(0,255)
            self.machine.leds['rgb_soup_circle'].color([colR ,colG ,colB ], 0, 0, 0, 1, 1)
            self.machine.leds['rgb_soup_arrow'].color([colR ,colG ,colB ], 0, 0, 0, 1, 1)

    def close(self):
        self.gate_state = 0
        self.machine.coils['soupdiverter'].disable()
        if self.machine.game:
            self.machine.events.post('soup_gate_close')
            self.machine.leds['rgb_soup_circle'].color([20, 0, 0 ], 0, 0, 0, 1, 1)
            self.machine.leds['rgb_soup_arrow'].color([20, 0, 0 ], 0, 0, 0, 1, 1)



