# popuppost Scriptlet for Nightmare

from mpf.system.scriptlet import Scriptlet
from mpf.system.timing import Timer
from mpf.system.timing import Timing
import random
import math
from mpf.system.tasks import DelayManager

class Popuppost(Scriptlet):

    def on_load(self):
        self.delay = DelayManager()
        self.systimer = Timer(callback=self.my_timer, frequency=15)
        self.machine.timing.add(self.systimer)
        self.post_state = 0

    def my_timer(self):
        if self.post_state == 0:
            self.log.info("Activate - Pop Up Post")
            self.move_up()
            delaytime = Timing.string_to_ms('5s')
            self.delay.add(name='disable_popuppost', ms=delaytime, callback=self.move_down)
        else:
            self.move_down()
            self.log.info("Deactivate - Pop Up Post")

    def disable(self):
        self.move_down()
        self.machine.timing.remove(self.systimer)

    def move_up(self):
        self.post_state = 1
        if self.machine.game:
            self.machine.coils['dissappearingpost'].enable()
#        colR = random.randint(0,256)
#        colG = random.randint(0,256)
#        colB = random.randint(0,256)
#        self.machine.leds['rgb_lorbit_circle'].color([colR ,colG ,colB ], 0, 0, 0, 1, 1)
#        self.machine.leds['rgb_lorbit_arrow'].color([colR ,colG ,colB ], 0, 0, 0, 1, 1)

    def move_down(self):
        self.post_state = 0
        self.machine.coils['dissappearingpost'].disable()
#        self.machine.leds['rgb_lorbit_circle'].color([20, 0, 0 ], 0, 0, 0, 1, 1)
#        self.machine.leds['rgb_lorbit_arrow'].color([20, 0, 0 ], 0, 0, 0, 1, 1)


