# Oogie Magnet Scriptlet for Nightmare

from mpf.system.scriptlet import Scriptlet
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing

class OogieMagnet(Scriptlet):

    def on_load(self):
        self.firedattick = 0
        self.delay = DelayManager()
        self.machine.switch_controller.add_switch_handler(
            'oogiebanktrap_opt', self.activate)
        self.machine.switch_controller.add_switch_handler(
            'subwayoogie_sw', self.deactivate)

    def enable(self):
        self.machine.switch_controller.add_switch_handler(
            'oogiebanktrap_opt', self.activate)
        self.machine.switch_controller.add_switch_handler(
            'subwayoogie_sw', self.deactivate)

    def disable(self):
        self.deactivate()
        self.machine.switch_controller.remove_switch_handler(
            'oogiebanktrap_opt', self.activate)
        self.machine.switch_controller.remove_switch_handler(
            'subwayoogie_sw', self.deactivate)

    def activate(self):
        self.log.info( "Oogie Magnet Opto - now: %s, prev: %s",Timing.tick, self.firedattick )                
        if Timing.tick - self.firedattick > 3000: 
            self.machine.coils['oogiemagnet'].enable()
            delaytime = Timing.string_to_ms('2s')
            self.delay.add(name='disable_oogie_magnet', ms=delaytime, callback=self.deactivate)
            self.firedattick = Timing.tick
            self.log.info( "Oogie Magnet ON - max 2s - tick: %s", Timing.tick )                        
        else:
            pulsetime = Timing.string_to_ms('24ms')
            self.log.info("Oogie Magnet - pulse for %s ms", pulsetime)        
            self.machine.coils['oogiemagnet'].pulse(pulsetime)

    def deactivate(self):
        self.log.info( "Oogie Magnet OFF" )
        self.machine.coils['oogiemagnet'].disable()
        
