# Oogie Loop Diverter Scriptlet for Nightmare

from mpf.system.scriptlet import Scriptlet
from mpf.system.timing import Timing
from mpf.system.tasks import DelayManager


class OogieDiverter(Scriptlet):

    def on_load(self):
        self.oogieloopmode = 0
        self.delay = DelayManager()
        self.enable()

    def enable(self):
        self.machine.switch_controller.add_switch_handler(
            'oogiecw_opt', self.timedactivate)
        self.machine.switch_controller.add_switch_handler(
            'oogieccw_opt', self.deactivate)
        self.machine.switch_controller.add_switch_handler(
            'oogiedivertertrap_opt', self.trapreleasetimer)
        self.machine.events.add_handler('toggle_loop_mode', self.toggleloopmode)

    def disable(self):
        self.deactivate()
        self.machine.switch_controller.remove_switch_handler(
            'oogiecw_opt', self.activate)
        self.machine.switch_controller.remove_switch_handler(
            'oogieccw_opt', self.deactivate)
        self.machine.switch_controller.remove_switch_handler(
            'oogiedivertertrap_opt', self.trapreleasetimer)

    def toggleloopmode(self):
        self.oogieloopmode = 1-self.oogieloopmode
        if self.oogieloopmode == 0:
            self.deactivate()

    def trapreleasetimer(self):
        if self.oogieloopmode == 0:
            delaytime = Timing.string_to_ms('2s')
            self.delay.add(name='release_trapped_ball', ms=delaytime, callback=self.timedactivate)

    def timedactivate(self):
        self.machine.coils['oogieloopdiverter'].enable()
        delaytime = Timing.string_to_ms('2s')
        self.delay.add(name='deactivate_delay', ms=delaytime, callback=self.deactivate)
        

    def activate(self):
        self.machine.coils['oogieloopdiverter'].enable()

    def deactivate(self):
        if self.oogieloopmode == 0:
            self.machine.coils['oogieloopdiverter'].disable()
        self.delay.remove('release_trapped_ball')

