# mayorDiverter Scriptlet for Nightmare

from mpf.system.scriptlet import Scriptlet
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timer
from mpf.system.timing import Timing
import random
import math

class mayorDiverter(Scriptlet):

    def on_load(self):
        self.delay = DelayManager()
        self.enabled = 1
        self.happy = 1
        self.machine.switch_controller.add_switch_handler(
            'rrampgate_sw', self.open_diverter)
        self.machine.events.add_handler('mayor_disable_diverter', self.disable_diverter)
        self.machine.events.add_handler('mayor_enable_diverter', self.enable_diverter)
        self.machine.events.add_handler('mayor_spin_1', self.set_sad)
        self.machine.events.add_handler('mayor_spin_2', self.set_happy)
        self.machine.coils['mayordiverter'].sneaky_servo(servo=11, position=95)        

    def enable_diverter(self):
        self.enabled = 1

    def disable_diverter(self):
        self.enabled = 0

    def set_happy(self):
        self.happy = 1
        self.log.info('Mayor sad')            

    def set_sad(self):
        self.happy = 0
        self.log.info('Mayor happy')            

    def open_diverter(self):
        if self.enabled ==1 and self.happy == 1:
            if self.machine.game:
                self.machine.coils['mayordiverter'].enable()
            delaytime = Timing.string_to_ms('5s')
            self.delay.add(name='mayor_close_diverter', ms=delaytime, callback=self.close_diverter)
            self.log.info("Activate - Mayor Diverter")

    def close_diverter(self):
        self.machine.coils['mayordiverter'].disable()
        self.log.info("Deactivate - Mayor Diverter")

    def disable(self):
        self.close_diverter()


