# soupdiverter Scriptlet for Nightmare

from mpf.system.scriptlet import Scriptlet
from mpf.system.timing import Timer
from mpf.system.timing import Timing
from mpf.system.tasks import DelayManager
import random
import math
import serial

class Gicomm(Scriptlet):

    def on_load(self):
        self.counter = 0
        self.index = 0
        self.command = 255
        self.dir = 1
        self.r = random.randint(50,150)
        self.g = random.randint(50,150)
        self.b = random.randint(50,150)
        self.rd = random.randint(-1,1)*random.randint(0,4)
        self.gd = random.randint(-1,1)*random.randint(0,4)
        self.bd = random.randint(-1,1)*random.randint(0,4)
        self.delay = DelayManager()
        self.serConnected = 0
        try:
            self.__ser = serial.Serial('COM3', 19200, timeout=10)
            print self.__ser.name
            self.serConnected = 1
        except serial.serialutil.SerialException:
            print 'Could not connect to comm3 - exception'

        if (self.serConnected == 1):
#            self.write_port(255, 0, 10, 10, 10)
            self.machine.switch_controller.add_switch_handler(
                'slingl_sw', self.switchmode)
            self.machine.switch_controller.add_switch_handler(
                'slingr_sw', self.switchmode1)
            self.machine.switch_controller.add_switch_handler(
                'doctor_sw', self.switchmode2)
            self.machine.switch_controller.add_switch_handler(
                'mystery_sw', self.switchmodeR)
        delaytime = Timing.string_to_ms('2s')
        self.delay.add(name='change_gi_lights', ms=delaytime, callback=self.timetochange)

    def switchmodeR(self):
        self.command = 253

    def switchmode1(self):
        self.counter = 0
        self.command = 254
        self.dir = -1
        self.index = 12
        self.r = random.randint(0,20)*10
        self.g = random.randint(0,20)*10
        self.b = random.randint(0,20)*10

    def switchmode(self):
        self.counter = 0
        self.command = 254
        self.dir = 1
        self.index = 11
        self.r = random.randint(0,20)*10
        self.g = random.randint(0,20)*10
        self.b = random.randint(0,20)*10

    def switchmode2(self):
        self.counter = 0
        self.command=255
        self.r = random.randint(0,20)*10
        self.g = random.randint(10,20)*10
        self.b = random.randint(0,20)*10
        if (random.randint(0,100) > 90):
            self.rd = random.randint(-1,1)*random.randint(2,6)
        if (random.randint(0,100) > 90):
            self.gd = random.randint(-1,1)*random.randint(2,6)
        if (random.randint(0,100) > 90):
            self.bd = random.randint(-1,1)*random.randint(2,6)
        for led in self.machine.leds:
           lname = led.name
           if lname.startswith('rgb_holiday'):
               self.machine.leds[lname ].color([self.r,self.g,self.b], 0, 0, 0, 1, 1)


    def timetochange(self): 
        if self.command == 255:
            delaytime = Timing.string_to_ms('100ms')
            if self.r < 0 or self.r > 255:
                self.r = self.r - self.rd
                self.rd = -self.rd
            if (random.randint(0,100) > 95):
                self.rd = random.randint(-1,1)*random.randint(1,4)
            self.g = self.g + self.gd
            if self.g < 0 or self.g > 255:
                self.g = self.g - self.gd
                self.gd = -self.gd
            if (random.randint(0,100) > 95):
                self.gd = random.randint(-1,1)*random.randint(1,4)
            self.b = self.b + self.bd
            if self.b < 0 or self.b > 255:
                self.b = self.b - self.bd
                self.bd = -self.bd
            if (random.randint(0,100) > 95):
                self.bd = random.randint(-1,1)*random.randint(1,4)
            self.writeToArduino()
            for led in self.machine.leds:
               lname = led.name
               if lname.startswith('rgb_holiday'):
                   self.machine.leds[lname ].color([self.r,self.g,self.b], 0, 0, 0, 1, 1)

        if self.command == 253:
            c = 254
            i = random.randint(0,25)
            r = random.randint(0,20)*10
            g = random.randint(0,20)*10
            b = random.randint(0,20)*10
            self.write_port(c, i, g, r, b)
            delaytime = Timing.string_to_ms('25ms')

        if self.command == 254:
            delaytime = Timing.string_to_ms('25ms')
            self.index = self.index + self.dir
#            if self.counter == 25:
#                self.counter = 0
#                self.r = random.randint(0,20)*10
#                self.g = random.randint(0,20)*10
#                self.b = random.randint(0,20)*10
            self.counter = self.counter + 1
            if self.index > 24:
                self.index = 0
            if self.index < 0:
                self.index = 24
            if self.counter < 26:
                self.writeToArduino()

        self.delay.add(name='change_gi_lights', ms=delaytime, callback=self.timetochange)

    def write_port(self,*data):  
        if self.serConnected == 1:
            try:
                for i in range(len(data)):
                    self.__ser.write(chr(data[i]))
            except serial.serialutil.SerialException:
                print 'Lost comm3 - exception'
                self.serConnected = 0
        
    def writeToArduino(self):
        sr = (self.r/10)*7
        sg = (self.g/10)*7
        sb = (self.b/10)*7
        #print str(self.r)+'='+str(sr)+','+str(self.g)+'='+str(sg)+','+str(self.b)+'='+str(sb)
        self.write_port(self.command, self.index, sg, sr, sb)

    def disable(self):
        if (self.serConnected == 1):
            self.__ser.close()



