# bathtub drain Scriptlet for Nightmare

from mpf.system.scriptlet import Scriptlet
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing

class BathtubDrain(Scriptlet):

    def on_load(self):
        self.balls_locked = 0
        self.multiball = 0
        self.delay = DelayManager()
        self.machine.switch_controller.add_switch_handler(
            'tublock1_opt', self.lock1, ms=1000)
        self.machine.switch_controller.add_switch_handler(
            'tublock2_opt', self.lock2, ms=1000)
        self.machine.switch_controller.add_switch_handler(
            'tublock3_opt', self.lock3, ms=1000)

    def lock3(self):
        if self.multiball == 0:
            self.machine.bcp.bcp_trigger('tub_ball_locked')
            if self.balls_locked == 2:
                #this is the 3rd ball, start MB
                self.startMB()
        else:
            #we are in MB, why are there 3 balls in tub?  
            #the tub diverter should be closed too!
            #ball 1 should be released
            self.activate()

    def lock2(self):
        if self.multiball == 0:
            print 'ball 2 locked'
            self.machine.bcp.bcp_trigger('tub_ball_locked')
            self.balls_locked = 2
            if self.machine.game:
                print 'launch another ball'
                self.machine.game.add_balls_in_play(1)
                self.machine.playfield.add_ball(balls=1, player_controlled=True)
        else:
            #we are in MB, why are there 3 balls in tub?  
            #the tub diverter should be closed too!
            #ball 1 should be released
            self.activate()

    def lock1(self):
        if self.multiball == 0:
            print 'ball 1 locked'
            self.machine.bcp.bcp_trigger('tub_ball_locked')
            self.balls_locked = 1
            if self.machine.game:
                print 'launch another ball'
                self.machine.game.add_balls_in_play(1)
                self.machine.playfield.add_ball(balls=1, player_controlled=True)
        else:
            #we are in MB, why is there a ball in tub?  
            #the tub diverter should be closed too!
            #ball 1 should be released
            self.activate()
         
    def startMB(self):
        #start multiball
        self.multiball = 1
        delaytime = Timing.string_to_ms('2s')
        self.delay.add(name='drain_bathtub', ms=delaytime, callback=self.slowrelease)
        self.machine.bcp.bcp_trigger('tub_mb_music_start')

    def slowrelease(self):
        self.balls_locked = self.balls_locked - 1
        self.activate()
        if self.balls_locked > 0:
            delaytime = Timing.string_to_ms('3s')
            self.delay.add(name='drain_bathtub', ms=delaytime, callback=self.slowrelease)

    def activate(self):
        self.machine.coils['bathtubdrain'].pulse()
