# bathtub Diverter Scriptlet for Nightmare

from mpf.system.scriptlet import Scriptlet
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing

class BathtubDiverter(Scriptlet):

    def on_load(self):
        self.delay = DelayManager()
        self.machine.switch_controller.add_switch_handler(
            'lrampgate_sw', self.activate)
        self.machine.switch_controller.add_switch_handler(
            'tublock3_opt', self.deactivate)

    def enable(self):
        self.machine.switch_controller.add_switch_handler(
            'lrampgate_sw', self.activate)
        self.machine.switch_controller.add_switch_handler(
            'tublock3_opt', self.deactivate)

    def disable(self):
        self.deactivate()
        self.machine.switch_controller.remove_switch_handler(
            'lrampgate_sw', self.activate)
        self.machine.switch_controller.remove_switch_handler(
            'tublock3_opt', self.deactivate)

    def activate(self):
        self.machine.coils['bathtubdiverter'].enable()
        delaytime = Timing.string_to_ms('5s')
        self.delay.add(name='disable_bathtub_diverter', ms=delaytime, callback=self.deactivate)

    def deactivate(self):
        self.machine.coils['bathtubdiverter'].disable()

