from mpf.system.mode import Mode

# Toys & Pop Bumpers                                                                                                                                                   Page 6
# 
# The pop bumpers are only worth 1,200 points per hit. 
# However, each time you hit one you also get a "Toy" which is a cumulative value kept 
# throughout the game which factors into your end of ball bonus, but is also a factor 
# for jackpots, timed modes, and the "Deliver the Presents" wizard mode.
# 
# Jackpots         All "jackpots" are increased by 10,000 points per toy you have. If the shot is worth a lot but is NOT a jackpot, it is unaffected.
# Timed Modes      All modes with time limits will get a 1 second increase to its initial time limit per 100 toys you have. Does not affect combos and non-mode timers.
# Presents         When in "Deliver the Presents" each present delivered actually drops your toy count by 1. More details can be found in the section for this mode.
# 
# Toys are often awarded from other methods as well, plus you can upgrade a single pop bumper 
# by spelling SANTA or by collecting the appropriate Mystery award, or there's also a mystery award 
# "Pops at Max" which will upgrade all three pop bumpers to triple value. The lights of the pops 
# change from white, to green, to red to indicate 1x, 2x, and 3x value, which affects both 
# the points awarded and the toys collected.
# 
# Also, any time a shot you make which scores toys happens to have a shot multiplier attached, 
# the toys awarded are also affected. Thus if you make a combo which
# awards 10 toys on a tripled shot, you get 30 toys!

class Toys(Mode):

    def mode_init(self):
        print 'Toys mode_init'

    def mode_start(self, **kwargs):
        print 'Toys mode_start'
        if self.player.toys_started == 0:
            self.player.toys_started = 1 
            self.player.toys_collected = 0
            self.player.toy_left_value = 1
            self.player.toy_right_value = 1
            self.player.toy_top_value = 1
        self.player.toys_at_max = 0
        self.add_mode_event_handler('sw_bumpertop', self.top_hit)
        self.add_mode_event_handler('sw_bumperleft', self.left_hit)
        self.add_mode_event_handler('sw_bumperright', self.right_hit)
        self.add_mode_event_handler('ball_starting', self.reset_toy_values)
        self.add_mode_event_handler("toy_pops_upgrade", self.upgrade_toy_values)        

    #reset at the start of each ball
    def reset_toy_values(self, **kwargs):
        self.player.toy_left_value = 1
        self.player.toy_right_value = 1
        self.player.toys_top_value = 1
        self.set_pop_lights()


    def upgrade_toy_values(self, **kwargs):
        if self.player.toy_left_value == 1:
            self.player.toy_left_value = 2
        elif self.player.toy_right_value == 1:
            self.player.toy_right_value = 2
        elif self.player.toy_top_value == 1:
            self.player.toy_top_value = 2
        elif self.player.toy_left_value == 2:
            self.player.toy_left_value = 3
        elif self.player.toy_right_value == 2:
            self.player.toy_right_value = 3
        elif self.player.toy_top_value == 2:
            self.player.toy_top_value = 3
            self.player.toys_at_max = 1
        if self.player.toys_at_max == 1:
            self.player.toys_collected += 10
            self.score = 50000   
            self.player["score"] += self.score
            self.machine.events.post('toys_collected_update',value=self.player.toys_collected)
        self.set_pop_lights()


    def set_pop_lights(self):
        self.machine.light_controller.stop_script(key="pop_1")
        self.machine.light_controller.stop_script(key="pop_2")
        self.machine.light_controller.stop_script(key="pop_3") 
        led = "grb_gi_25"
        script_name = "sc_pop_"+str(self.player.toy_top_value)
        scp = self.machine.light_controller.registered_light_scripts[script_name]
        self.machine.light_controller.run_script(leds=led, script=scp, priority=40, tocks_per_sec=80, key="pop_1")
        led = "grb_gi_24"
        script_name = "sc_pop_"+str(self.player.toy_left_value)
        scp = self.machine.light_controller.registered_light_scripts[script_name]
        self.machine.light_controller.run_script(leds=led, script=scp, priority=40, tocks_per_sec=80, key="pop_2")
        led = "grb_gi_26"
        script_name = "sc_pop_"+str(self.player.toy_right_value)
        scp = self.machine.light_controller.registered_light_scripts[script_name]
        self.machine.light_controller.run_script(leds=led, script=scp, priority=40, tocks_per_sec=80, key="pop_3")


        
    def right_hit(self, **kwargs):
        print 'right bumper hit'
        self.player.toys_collected += self.player.toy_right_value 
        self.score = 1200   #TODO maybe factor in playfield multiplier here
        self.player["score"] += self.score
        self.machine.events.post('toys_collected_update',value=self.player.toys_collected)

    def left_hit(self, **kwargs):
        print 'left bumper hit'
        self.player.toys_collected += self.player.toy_left_value 
        self.score = 1200   #TODO maybe factor in playfield multiplier here
        self.player["score"] += self.score
        self.machine.events.post('toys_collected_update',value=self.player.toys_collected)

    def top_hit(self, **kwargs):
        print 'top bumper hit'
        self.player.toys_collected += self.player.toy_top_value 
        self.score = 1200   #TODO maybe factor in playfield multiplier here
        self.player["score"] += self.score
        self.machine.events.post('toys_collected_update',value=self.player.toys_collected)

    def mode_stop(self, **kwargs):
        print 'Toys mode_stop'
        self.machine.light_controller.stop_script(key="pop_1")
        self.machine.light_controller.stop_script(key="pop_2")
        self.machine.light_controller.stop_script(key="pop_3") 


