from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing


# Soup Hurry-Up
# If you get 100 stitches in normal play (outside of all modes and so long as the hurry up is not running) 
# it starts the Soup Hurry-Up where you must get the ball to the
# Soup Shot under the upper flipper within 15 seconds. The base value of the hurry up starts at 2,000,000 
# and after 2 seconds starts dropping by 4% of its base
# value every quarter-second down to a minimum value of 10% of the base value. 
# Every stitch earned from the spinner while the hurry up is running increases the
# base value by 50,000 points for the rest of the game. 
# If the shooter lane diverter is open when you make the Soup Shot you still get the hurry up award.
 

class Soup_Hurry(Mode):

# runs on MPF boot when the mode is read in and set up.
    def mode_init(self):
        print 'Soup Hurry-Up mode_init'

    def mode_start(self, **kwargs):
        print 'Soup Hurry-Up mode_start'
        self.delay = DelayManager()        
        if self.player.soup_hurry_started == 0:
            self.player.soup_hurry_started = 1 
            self.player.soup_hurry_base_value = 2000000
            self.player.soup_hurry_min_value = 200000            
        #when mode starts, start with the base value
        self.player.soup_hurry_current_value = self.player.soup_hurry_base_value
        self.player.soup_hurry_min_value = self.player.soup_hurry_current_value * 0.1 #10 percent 
        self.add_mode_event_handler('sw_sally', self.spin)
        self.add_mode_event_handler('sw_soupentrance', self.tastesoup)
        self.player.soup_hurry_ticker = 15*4  #15 seconds 
        delaytime = Timing.string_to_ms('250ms')
        self.delay.add(name='soup_hurry_ticker', ms=delaytime, callback=self.ticker)

    def spin(self, **kwargs):
        print 'Soup Hurry-Up - spin'
        #increase the soup starting value for next time
        self.machine.game.player.soup_hurry_base_value += 50000
        
    def tastesoup(self, **kwargs):
        print 'Soup Hurry-Up - collected' 
        if self.machine.game.player.soup_hurry_ticker > 0:
            self.score = int(self.player.soup_hurry_current_value/10)*10
            self.score = self.score * self.player.multiplier_shot_value_list[9] 
            self.player["score"] += (self.score)
            self.machine.events.post('taste_the_soup_completed',value=self.score)
            self.delay.remove('soup_hurry_ticker')
            self.machine.game.player.soup_hurry_ticker = 0

    def ticker(self):
        print 'Soup Hurry-Up 250ms tick'
        if self.player.soup_hurry_ticker == 60:
            self.machine.events.post('say_ready_yet')
        self.machine.game.player.soup_hurry_ticker -= 1
        #after 2 seconds, start decrementing the value
        if self.player.soup_hurry_ticker < (60-2*4):
            self.machine.game.player.soup_hurry_current_value = self.machine.game.player.soup_hurry_current_value * .96
            #dont go below the 10% of base value
            if self.machine.game.player.soup_hurry_current_value < self.machine.game.player.soup_hurry_min_value:
                self.machine.game.player.soup_hurry_current_value = self.machine.game.player.soup_hurry_min_value
        self.machine.events.post('soup_hurry_points',value=int(self.machine.game.player.soup_hurry_current_value/10)*10)
        #ran out of time - stop mode
        if self.player.soup_hurry_ticker <= 0:
            self.delay.remove('soup_hurry_ticker')
            self.player.soup_hurry_ticker = 0
            self.machine.events.post('soup_hurry_stopped')
        else:
            delaytime = Timing.string_to_ms('250ms')
            self.delay.add(name='soup_hurry_ticker', ms=delaytime, callback=self.ticker)

           
    def mode_stop(self, **kwargs):
        print 'Soup Hurry-Up mode_stop'
        self.delay.remove('soup_hurry_ticker')
        self.player.soup_hurry_ticker = 0
        self.machine.events.post('soup_hurry_stopped')        
