from mpf.system.mode import Mode

# TODO - add Super and Secret skill shots
# Skill Shots
# 
# Skill Shot #1
# If you soft-plunge into the Bathtub Hole, you get a 1,000,000 skill shot, multiplied by the current ball number.
# 
# Skill Shot #2
# If you soft-plunge to the upper-right flipper and make the left toy-orbit shot, 
# you will get a Skill Shot worth a fixed 2,500,000 points. 
# This is the best one to go for on Ball 1 and 2, however, for Ball 3 (and 4/5 if playing a 5-ball game) 
# you're better off going with Skill Shot #1.
# 
# Super Skill Shot
# Normally, if you attempt to full-plunge, the popup post will cause the ball to fall into the toy pops. 
# If you hold the left flipper up while plunging, the popup post will go down (and stay down) the instant 
# the ball leaves the shooter lane, allowing the ball to go all the way around the orbit. 
# Simply make any major shot after this without qualifying the playfield to score 4,000,000 points and 25 toys. 
# All major shot triangles will flash cyan to indicate that you're ready to go for a Super Skill Shot.
# 
# Secret Skill Shot
# If you want to get really crazy, soft-plunge the ball and get it down to the main flippers without 
# hitting any switches or slingshots, then shoot the right ramp. 
# This will always send the ball into the Zero lane and will award a "Secret Skill Shot" worth 1,000,000 points, 
# multiplied by the current ball number, 25 toys, lowers the Oogie Boogie gate if it's up, 
# increases the bonus multiplier by 1x, and opens the shooter lane diverter on the Soup Shot for 10 
# seconds as though you had just made the Soup Shot, making it possible to immediately go for a shot tripler. 
# The game will actually flash the right ramp triangle cyan after about seven seconds if it thinks
# you're in the process of doing this, detected by confirming that the ball is not in the shooter lane, 
# that you didn't qualify a Super Skill Shot, that no switches have
# been hit, and that one of the flippers has been up for seven seconds straight.

class Skill_Shot(Mode):

# runs on MPF boot when the mode is read in and set up.
    def mode_init(self):
        print 'Skill_Shot mode_init'

    def mode_start(self, **kwargs):
        print 'Skill_Shot mode_start'
        if self.machine.game.player.skill_shot_started == 0:
            self.machine.game.player.skill_shot_started = 1 
            self.machine.game.player.sally_spins = 0
            self.machine.game.player.skill_shot_1_collected = 0
            self.machine.game.player.skill_shot_2_collected = 0
            self.machine.game.player.skill_shot_3_collected = 0
            self.machine.game.player.skill_shot_4_collected = 0
        self.skillshot_collected = 0
        self.add_mode_event_handler('sneakin_singlestep_unlit_hit', self.skill_1)
        self.add_mode_event_handler('major_3_singlestep_unlit_hit', self.skill_2)

        
    def skill_1(self, **kwargs):
        if self.skillshot_collected == 0:
            print 'Skill_Shot 1 - sneakin' 
            self.machine.game.player.skill_shot_1_collected += 1
            self.score = 1000000 * self.machine.game.player.ball 
            self.player["score"] += self.score
            self.machine.events.post("skill_shot_completed",value=self.score)
            self.skillshot_collected = 1

    def skill_2(self, **kwargs):
        if self.skillshot_collected == 0:    	
            print 'Skill_Shot 2 - left inner loop' 
            self.machine.game.player.skill_shot_2_collected += 1
            self.score = 2500000 
            self.player["score"] += self.score
            self.machine.events.post('skill_shot_completed',value=self.score)

                
    def mode_stop(self, **kwargs):
        print 'Skill_Shot mode_stop'


