from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Oogie Boogie Mode #6 - "Oogie Boogie's Unravelling" Multiball                                                                                                       Page 36
# 
# Brief Description
# This is a very unusual 3-ball multiball frenzy where all targets are worth points, but you don't actually get any of the points until you're down to one ball, at which point
# you have 15 seconds to get the ball into Oogie Boogie's lair, or the mode is failed and you don't get anything.
# 
# Scenario
# Jack is ready to unravel Oogie Boogie, but he has to be careful in case Oogie Boogie happens to have an ace up his non-existent sleeves!
# 
# Details
# This is a 3-ball multiball, but not in a traditional sense. When this mode begins, the whole playfield lights up and every switch is worth 50,000 points, the value of
# which can be raised by hitting the gate, which stays up for most of the multiball. However, none of the frenzy points scored while this mode is active will actually be
# given to the player, and instead are getting "Banked" according to the display. (Non-frenzy scoring will still be awarded as normal so as to be compatible with any
# other modes which happen to be running.) Once two balls have drained and only one ball remains, the gate finally goes down and you have 15 seconds to get the
# ball into Oogie Boogie's lair to finish the mode and score your banked points. Failing to do this will end the mode without awarding any of your banked points. (But at
# least you'll be able to play the mode again.)
# 
# Scoring
# Every Switch                        50,000 (Banked)
# Frenzy Value Increments             2,500 (5,000 if two targets hit on gate simultaneously, 7,500 if all three)
# 
# Lighting
# All the lights go crazy during this mode, though the gate lights will rapidly flash white. Once you're down to one ball, ALL of the playfield lights go out, except for the
# gate lights which will pulse yellow to alert the player to shoot for the lair ASAP!
# 
# Difficulty Adjustments
# Very Easy         4-Ball Multiball, 25 Seconds to Make Final Shot
# Easy              3-Ball Multiball, 20 Seconds to Make Final Shot
# Normal            3-Ball Multiball, 15 Seconds to Make Final Shot
# Hard              3-Ball Multiball, 12 Seconds to Make Final Shot
# Very Hard         2-Ball Multiball, 10 Seconds to Make Final Shot

class OB_Unravel(Mode):

    def mode_init(self):
        print 'OB_Unravel mode_init'

    def mode_start(self, **kwargs):
        print 'OB_Unravel mode_start'
        self.delay = DelayManager()
        if self.player.OB_mode_6_started == 0:
            #once per game only
            self.player.OB_mode_6_started = 1
            self.player.OB_mode_6_running = 0
        self.ticks = 20  #TODO
        self.add_mode_event_handler('sw_oogietarget2', self.bug2)
        self.targets_list = [
            {"led":"rgb_bug_2", "state":"unlit"}
            ]
        self.blueflash = []
        self.blueflash.append({'color': '000033', 'time': 200, 'tocks': 10})
        self.blueflash.append({'color': '000099', 'time': 200, 'tocks': 10})
        self.blueflash.append({'color': '0000ff', 'time': 200, 'tocks': 10})
        self.blueflash.append({'color': '000099', 'time': 200, 'tocks': 10})
        self.start_battle()
        
        
    def bug2(self, **kwargs):
        print "bug 2 called in OB_Unravel"
        if self.player:
            if (self.player.OB_mode_6_running == 1):
                self.hit_target(0)
        else:
            print "call to a mode without a player object?"


    def hit_target(self, x):
        nb = random.randint(1,6)
        self.machine.events.post('bug_splat_'+str(nb))
        self.player["score"] += (22220)
        self.turn_off_bug_light(x)
        self.set_bug_light(x)


    def end_battle(self):
        if (self.player.OB_mode_6_running == 1):
            self.player.OB_mode_6_running = 2
            self.machine.events.post('OB_Unravel_music_stop')
            print "OB mode 6 over"
            self.turn_off_bug_light(0)
            self.delay.remove('OB_mode_6_ticker')  
            self.machine.events.post('ob_mode_stopped', ob_state="complete", ob_mode="6")                            


    def start_battle(self):
        print "In The Oogie hole - start the battle?"
        if (self.player.OB_mode_6_running == 0):
            self.set_bug_light_state(0, 'blue')
            self.set_bug_light(0)
            self.player.OB_mode_6_running = 1
            self.machine.bcp.bcp_trigger('OB_Unravel_music_start')
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name='OB_mode_6_ticker', ms=delaytime, callback=self.ticker)
            print "60 seconds to hide Santa"

    def ticker(self):
        print "500ms tick"
        self.machine.events.post('unravel_OB_countdown', value=int(self.ticks))
        self.ticks -= 0.5;
        if self.ticks <= 0:
            self.end_battle()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name='OB_mode_6_ticker', ms=delaytime, callback=self.ticker)


    def set_bug_light_state(self, x, state):
        self.targets_list[x]["state"] = state

    def set_bug_light(self, x):
        led = self.targets_list[x]["led"]
        state = self.targets_list[x]["state"]
        if state == 'blue':
            self.machine.light_controller.run_script(leds=led,script=self.blueflash ,priority=50, tocks_per_sec=80, key=led+"_"+state, blend=True)

    def turn_off_bug_light(self, x):
       print "turn off bug light"
       led = self.targets_list[x]["led"]
       state = self.targets_list[x]["state"]
       self.machine.light_controller.stop_script(led+"_"+state)
       self.machine.leds[led].color([10 ,10 ,10 ], 0, 0, 0, 1, 1) 


    def mode_stop(self, **kwargs):
        print 'OB_Unravel mode_stop'
        self.end_battle()

