from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Oogie Boogie Mode #2 - "Santa vs. Oogie Boogie"                                                                                                                    Page 32
# 
# Brief Description
# You must hide from Oogie Boogie by shooting for any shot which would get the ball off of the playfield. In fact, the instructions on the display simply say, "Get the ball
# off the playfield!"
# 
# Scenario
# Santa has no hope in combat against Oogie Boogie, so he hatches a plan to escape, but Oogie Boogie is effortlessly tracking him in the dark! You must find Santa
# someplace to hide!
# 
# Details
# This mode has a 60 second time limit and NO ball saver. The reason for having no ball saver is because one of the potential hiding places for getting the ball off of
# the playfield... is the drain! Thus the first time you drain the ball in this mode actually counts as hiding from Oogie Boogie, but because you can't use the same hiding
# space more than once, draining a second time will end the ball as normal. This mode kills the playfield lighting, though things will still flash briefly when you shoot
# them so that the player knows the game isn't broken. Other places you can hide the ball include the hinterlands, the graveyard, soup and the mayor. Hide the ball in
# three different places to complete the mode... with Santa getting captured. Oh well, can't say he didn't TRY!
# 
# Scoring
# 1st Hiding Place     500,000
# 2nd Hiding Place   1,000,000
# 3rd Hiding Place   2,500,000
# 
# Lighting
# The entire playfield goes dark for this mode, but shots will flash briefly when you hit them so the player doesn't think the game's broken.
# 
# Difficulty Adjustments
# Very Easy          90 Second Time Limit, Need to Hide 2 Times to Win
# Easy               90 Second Time Limit, Need to Hide 3 Times to Win
# Normal             60 Second Time Limit, Need to Hide 3 Times to Win
# Hard               60 Second Time Limit, Need to Hide 4 Times to Win
# Very Hard          40 Second Time Limit, Need to Hide 4 Times to Win

class OB_Santa(Mode):

    def mode_init(self):
        print 'OB_Santa mode_init'

    def mode_start(self, **kwargs):
        print 'OB_Santa mode_start'
        self.delay = DelayManager()
        if self.player.OB_mode_2_started == 0:
            #once per game only
            self.player.OB_mode_2_started = 1
            self.player.OB_mode_2_running = 0
        self.ticks = 20  #TODO change to 60 seconds
        self.add_mode_event_handler('sw_oogietarget2', self.bug2)
        self.targets_list = [
            {"led":"rgb_bug_2", "state":"unlit"}
            ]
        self.blueflash = []
        self.blueflash.append({'color': '000033', 'time': 200, 'tocks': 10})
        self.blueflash.append({'color': '000099', 'time': 200, 'tocks': 10})
        self.blueflash.append({'color': '0000ff', 'time': 200, 'tocks': 10})
        self.blueflash.append({'color': '000099', 'time': 200, 'tocks': 10})
        self.start_battle()

    def bug2(self, **kwargs):
        print "bug 2 called in OB_Santa"
        if self.player:
            if (self.player.OB_mode_2_running == 1):
                self.hit_target(0)

    def hit_target(self, x):
        nb = random.randint(1,6)
        self.machine.events.post('bug_splat_'+str(nb))
        self.player["score"] += (22220)
        self.turn_off_bug_light(x)
        self.set_bug_light(x)


    def end_battle(self):
        if (self.player.OB_mode_2_running == 1):
            self.player.OB_mode_2_running = 2
            self.machine.events.post('OB_Santa_music_stop')
            print "OB mode 2 over"
            self.turn_off_bug_light(0)
            self.delay.remove('OB_mode_2_ticker')  
            self.machine.events.post('ob_mode_stopped', ob_state="complete", ob_mode="2")

    def start_battle(self):
        print "In The Oogie hole - start the battle?"
        if (self.player.OB_mode_2_running == 0):
            self.set_bug_light_state(0, 'blue')
            self.set_bug_light(0)
            self.player.OB_mode_2_running = 1
            self.machine.bcp.bcp_trigger('OB_Santa_music_start')
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name='OB_mode_2_ticker', ms=delaytime, callback=self.ticker)
            print "60 seconds to hide Santa"

    def ticker(self):
        print "500ms tick"
        self.machine.events.post('santa_OB_countdown', value=int(self.ticks))
        self.ticks -= 0.5;
        if self.ticks <= 0:
            self.end_battle()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name='OB_mode_2_ticker', ms=delaytime, callback=self.ticker)


    def set_bug_light_state(self, x, state):
        self.targets_list[x]["state"] = state

    def set_bug_light(self, x):
        led = self.targets_list[x]["led"]
        state = self.targets_list[x]["state"]
        if state == 'blue':
            self.machine.light_controller.run_script(leds=led,script=self.blueflash ,priority=50, tocks_per_sec=80, key=led+"_"+state, blend=True)

    def turn_off_bug_light(self, x):
       print "turn off bug light"
       led = self.targets_list[x]["led"]
       state = self.targets_list[x]["state"]
       self.machine.light_controller.stop_script(led+"_"+state)
       self.machine.leds[led].color([10 ,10 ,10 ], 0, 0, 0, 1, 1) 


    def mode_stop(self, **kwargs):
        print 'OB_Santa mode_stop'
        self.end_battle()

