from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random
 
# Oogie Boogie Mode #3 - "Sally vs. Oogie Boogie"                                                                                                                 Page 33
# 
# Brief Description
# Health-bar limited mode where you must make shots to keep the mode going as long as you can... at least until you reach a target score.
# 
# Scenario
# Sally's trying to rescue Santa a decides to distract Oogie Boogie with one of her detached legs. But, it's only a matter of time before Oogie Boogie figures it out, so
# you have to keep him going as long as you can!
# 
# Details
# The health bar for this mode is actually more like a timer and will last 15 seconds. Three random, major shots will be lit for 250,000 points each and will reset the
# health bar to maximum as well. When you make one major shot, all three lit major shots will change. The spinner however will be lit for 50,000 points per spin and
# will never be selected as a random major shot, while Soup will award you all the points you've accumulated for the mode again, thus if you've scored 312,510 points
# since starting the mode, the soup shot will award this many points. To complete the mode you must accumulate 2,000,000 points while it's running, which will
# effectively end the mode as well.
# 
# Scoring
# Lit Major Shot            250,000
# Spinner Spin              50,000
# Soup                      Equal to Number of Points Accumulated Since Starting the Mode
# 
# Lighting
# The spinner rapidly flashes an orange triangle, lit major shots flash yellow triangles, soup flashes a white triangle and circle.
# 
# Difficulty Adjustments
# Very Easy         Health Bar Lasts 18 Seconds, 4 Major Shots Lit at a Time, Need 1,500,000 Points to Complete
# Easy              Health Bar Lasts 15 Seconds, 4 Major Shots Lit at a Time, Need 1,750,000 Points to Complete
# Normal            Health Bar Lasts 15 Seconds, 3 Major Shots Lit at a Time, Need 2,000,000 Points to Complete
# Hard              Health Bar Lasts 12 Seconds, 3 Major Shots Lit at a Time, Need 2,250,000 Points to Complete
# Very Hard         Health Bar Lasts 12 Seconds, 2 Major Shots Lit at a Time, Need 2,500,000 Points to Complete

class OB_Sally(Mode):

    def mode_init(self):
        print 'OB_Sally mode_init'

    def mode_start(self, **kwargs):
        print 'OB_Sally mode_start'
        self.delay = DelayManager()
        if self.player.OB_mode_3_started == 0:
            #once per game only
            self.player.OB_mode_3_started = 1
            self.player.OB_mode_3_running = 0
        self.ticks = 15
        self.add_mode_event_handler('sw_oogietarget2', self.bug2)
        self.targets_list = [
            {"led":"rgb_bug_2", "state":"unlit"}
            ]
        self.blueflash = []
        self.blueflash.append({'color': '000033', 'time': 200, 'tocks': 10})
        self.blueflash.append({'color': '000099', 'time': 200, 'tocks': 10})
        self.blueflash.append({'color': '0000ff', 'time': 200, 'tocks': 10})
        self.blueflash.append({'color': '000099', 'time': 200, 'tocks': 10})
        self.start_battle()
        
        
    def bug2(self, **kwargs):
        if (self.player.OB_mode_3_running == 1):
            self.hit_target(0)


    def hit_target(self, x):
        nb = random.randint(1,6)
        self.machine.events.post('bug_splat_'+str(nb))
        self.player["score"] += (33330)
        self.turn_off_bug_light(x)
        self.set_bug_light(x)


    def end_battle(self):
        if (self.player.OB_mode_3_running == 1):
            self.player.OB_mode_3_running = 2
            self.machine.events.post('OB_Sally_music_stop')
            print "OB mode 3 over"
            self.turn_off_bug_light(0)
            self.delay.remove('OB_mode_3_ticker')  
            self.machine.events.post('ob_mode_stopped', ob_state="complete", ob_mode="3")

    def start_battle(self):
        print "In The Oogie hole - start the battle?"
        if (self.player.OB_mode_3_running == 0):
            self.set_bug_light_state(0, 'blue')
            self.set_bug_light(0)
            self.player.OB_mode_3_running = 1
            self.machine.bcp.bcp_trigger('OB_Sally_music_start')
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name='OB_mode_3_ticker', ms=delaytime, callback=self.ticker)
            print "60 seconds to hide Santa"

    def ticker(self):
        print "500ms tick"
        self.machine.events.post('sally_OB_countdown', value=int(self.ticks))
        self.ticks -= 0.5;
        if self.ticks <= 0:
            self.end_battle()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name='OB_mode_3_ticker', ms=delaytime, callback=self.ticker)


    def set_bug_light_state(self, x, state):
        self.targets_list[x]["state"] = state

    def set_bug_light(self, x):
        led = self.targets_list[x]["led"]
        state = self.targets_list[x]["state"]
        if state == 'blue':
            self.machine.light_controller.run_script(leds=led,script=self.blueflash ,priority=50, tocks_per_sec=80, key=led+"_"+state, blend=True)

    def turn_off_bug_light(self, x):
       print "turn off bug light"
       led = self.targets_list[x]["led"]
       state = self.targets_list[x]["state"]
       self.machine.light_controller.stop_script(led+"_"+state)
       self.machine.leds[led].color([10 ,10 ,10 ], 0, 0, 0, 1, 1) 


    def mode_stop(self, **kwargs):
        print 'OB_Sally mode_stop'
        self.end_battle()

