from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Oogie Boogie Mode #5 - "Jack vs. Oogie Boogie"                                                                                                                 Page 35
# 
# Brief Description
# Several major shots need to be cleared, but the time limit is too small to work within. You must shoot the spinner to build up more time, then you can focus on the
# major shots.
# 
# Scenario
# Jack and Oogie Boogie are battling it out! Actually, it's more precise to say Oogie Boogie is sending Jack through a gauntlet full of traps and Jack's having to dodge
# everything.
# 
# Details
# This mode only gives you a 15 second time limit to shoot 8 of the major shots. (The only two major shots not lit are the spinner and Graveyard.) This is too small of a
# time limit, obviously, so you need to get more time by shooting the spinner. Each spinner spin adds 2 seconds to the timer. Once a major shot is cleared it unlights.
# Hit all eight lit major shots and the mode is completed.
# 
# Scoring
# Lit Major Shot             1,000,000
# Last Major Shot            5,000,000
# Spinner Spin               20,000 and +2 Seconds
# 
# Lighting
# Major shots you still need to hit flash a yellow triangle. The spinner rapidly flashes both a blue triangle and circle.
#            
# Difficulty Adjustments
# Very Easy          20 second initial time limit, 7 major shots to shoot.
# Easy               15 second initial time limit, 7 major shots to shoot.
# Normal             15 second initial time limit, 8 major shots to shoot.
# Hard               12 second initial time limit, 8 major shots to shoot.
# Very Hard          10 second initial time limit, 8 major shots to shoot.

class OB_Jack(Mode):

    def mode_init(self):
        print 'OB_Jack mode_init'

    def mode_start(self, **kwargs):
        print 'OB_Jack mode_start'
        self.delay = DelayManager()
        if self.player.OB_mode_5_started == 0:
            #once per game only
            self.player.OB_mode_5_started = 1
            self.player.OB_mode_5_running = 0
        self.ticks = 20
        self.add_mode_event_handler('sw_oogietarget2', self.bug2)
        self.targets_list = [
            {"led":"rgb_bug_2", "state":"unlit"}
            ]
        self.blueflash = []
        self.blueflash.append({'color': '000033', 'time': 200, 'tocks': 10})
        self.blueflash.append({'color': '000099', 'time': 200, 'tocks': 10})
        self.blueflash.append({'color': '0000ff', 'time': 200, 'tocks': 10})
        self.blueflash.append({'color': '000099', 'time': 200, 'tocks': 10})
        self.start_battle()

    def bug2(self, **kwargs):
        print "bug 2 called in OB_Jack"
        if self.player:
            if (self.player.OB_mode_5_running == 1):
                self.hit_target(0)
        else:
            print "call to a mode without a player object?"


    def hit_target(self, x):
        nb = random.randint(1,6)
        self.machine.events.post('bug_splat_'+str(nb))
        self.player["score"] += (22220)
        self.turn_off_bug_light(x)
        self.set_bug_light(x)


    def end_battle(self):
        if (self.player.OB_mode_5_running == 1):
            self.player.OB_mode_5_running = 2
            self.machine.events.post('OB_Jack_music_stop')
            print "OB mode 5 over"
            self.turn_off_bug_light(0)
            self.delay.remove('OB_mode_5_ticker')  
            self.machine.events.post('advance_to_next_mode')
            self.machine.events.post('ob_mode_stopped', ob_state="complete", ob_mode="5")            

    def start_battle(self):
        print "In The Oogie hole - start the battle?"
        if (self.player.OB_mode_5_running == 0):
            self.set_bug_light_state(0, 'blue')
            self.set_bug_light(0)
            self.player.OB_mode_5_running = 1
            self.machine.bcp.bcp_trigger('OB_Jack_music_start')
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name='OB_mode_2_ticker', ms=delaytime, callback=self.ticker)


    def ticker(self):
        print "500ms tick"
        if self.ticks < (20-4):  #enough time for video
            self.machine.events.post('Jack_OB_countdown', value=int(self.ticks))
        self.ticks -= 0.5;
        if self.ticks <= 0:
            self.end_battle()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name='OB_mode_5_ticker', ms=delaytime, callback=self.ticker)


    def set_bug_light_state(self, x, state):
        self.targets_list[x]["state"] = state

    def set_bug_light(self, x):
        led = self.targets_list[x]["led"]
        state = self.targets_list[x]["state"]
        if state == 'blue':
            self.machine.light_controller.run_script(leds=led,script=self.blueflash ,priority=50, tocks_per_sec=80, key=led+"_"+state, blend=True)

    def turn_off_bug_light(self, x):
       print "turn off bug light"
       led = self.targets_list[x]["led"]
       state = self.targets_list[x]["state"]
       self.machine.light_controller.stop_script(led+"_"+state)
       self.machine.leds[led].color([10 ,10 ,10 ], 0, 0, 0, 1, 1) 


    def mode_stop(self, **kwargs):
        print 'OB_Jack mode_stop'
        self.end_battle()

