from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Oogie Boogie Mode #4 - "Luck o' the Dice"                                                                                                                            Page 34
# 
# Brief Description
# You must get the ball into the pops to change the values of Oogie Boogie's dice rolls. 
# If the cumulative value of all of his dice rolls exceeds 32, the mode ends.
# 
# Scenario
# Santa and Sally are perilously tied up on an insidious platform Oogie Boogie has. 
# If Oogie Boogie presses the lever of his machine enough times, Santa and Sally
# are doomed! Thankfully, he's decided to leave the number of his presses up to random chance...
# 
# Details
# When this mode begins, a random roll of the dice is shown on-screen (total value of 9 or higher) 
# and after 10 seconds elapse, or you shoot the right ramp, this will be
# what Oogie Boogie actually rolls. If you're not satisfied with the value currently shown, you 
# need to get the ball up into the pops. To that end, the popup post will
# activate during the course of this mode. Each pop bumper hit will change the highest die to a 
# new random value from 1 to 6 and will delay the timer for a moment
# until the pops aren't being hit anymore. Chances are good that you will at least get one die 
# down to 1 with enough pop bumper hits, at which point the highest roll
# possible becomes 7. This is good because to complete this mode, you must survive four dice 
# rolls without reaching or exceeding a cumulative value of 32. Once
# Oogie Boogie rolls the dice, the new value to come up will always be at least 9. 
# The gate to Oogie Boogie's lair remains down for the duration of this mode and
# shooting the lair immediately awards 1,000,000 points, but also re-randomizes both dice 
# without resetting the timer. If you make it past four dice rolls, Jack breaks in
# and distracts Oogie Boogie, though you only see Oogie Boogie's reaction on the display so 
# as to instill a sense of wonder as to the next mode. If you fail to survive
# four rolls, Santa and Sally fall in and Oogie Boogie proclaims, "Better luck next time!"
# 
# Scoring
# Survive 1st Dice Roll        500,000
# Survive 2nd Dice Roll      1,000,000
# Survive 3rd Dice Roll      1,500,000
# Survive 4th Dice Roll      2,000,000
# Survive 5th Dice Roll      2,500,000
# Early Roll             Extra 500,000 if you survive
# Lair Shot                  1,000,000
# 
# Lighting
# The right ramp will show a solid red triangle with any dice roll value higher than 7. A value of 7 will flash a yellow triangle on the right ramp. A value less than 7 will
# flash a green triangle on the right ramp. The pops will also be flashing in a particular lighting pattern to get the player's attention to shoot for them. The bug lights in
# front of the lair flash red.
# 
# Difficulty Adjustments
# Very Easy           Need to survive 3 rolls
# Easy                Need to survive 3 rolls
# Normal              Need to survive 4 rolls
# Hard                Need to survive 4 rolls
# Very Hard           Need to survive 5 rolls

class OB_Dice(Mode):

    def mode_init(self):
        print 'OB_Dice mode_init'

    def mode_start(self, **kwargs):
        print 'OB_Dice mode_start'
        self.delay = DelayManager()
        self.ticks = 0
        self.player.OB_mode_4_running = 0
        self.player.OB_mode_4_ticks = 20  #20 = 10 seconds
        self.player.OB_mode_4_rolls_needed = 4
        self.player.OB_mode_4_rolls_made = 0
        
        self.add_mode_event_handler('sw_oogietarget2', self.bug2)
        self.targets_list = [
            {"led":"rgb_bug_2", "state":"unlit"}
            ]
        self.start_battle()


    def start_battle(self):
        if self.player.OB_mode_4_running == 0:
            print "In The Oogie hole - start Dice"
            self.player.OB_mode_4_running = 1
            self.set_bug_light_state(0, 'blue')
            self.set_bug_light(0)
            self.machine.bcp.bcp_trigger('OB_Dice_music_start')
            self.ticks = self.player.OB_mode_4_ticks 
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="OB_mode_4_ticker", ms=delaytime, callback=self.ticker)
            self.machine.events.post('popuppost_enable_up')


    def accept_roll(self):
        print "Dice mode - accept roll"    
        self.player.OB_mode_4_rolls_made += 1
        if self.player.OB_mode_4_rolls_made < 3:
            self.ticks = self.player.OB_mode_4_ticks 
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="OB_mode_4_ticker", ms=delaytime, callback=self.ticker)
        else:
            self.end_battle()
        
    
    def ticker(self):
        print "Dice mode - 500ms tick"
        self.timeleft = int(self.ticks/2)
        self.machine.events.post("OB_dice_countdown", value=self.timeleft)
        self.ticks -= 1;
        if self.ticks <= 0:
            self.accept_roll()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="OB_mode_4_ticker", ms=delaytime, callback=self.ticker)

    def end_battle(self):
        if (self.player.OB_mode_4_running == 1):
            self.player.OB_mode_4_running = 2
            self.machine.events.post('OB_Dice_music_stop')
            print "OB mode 2 over"
            self.turn_off_bug_light(0)
            self.machine.events.post('ob_mode_stopped', ob_state="complete", ob_mode="4")
            self.machine.events.post('popuppost_disable_up')


    def bug2(self, **kwargs):
        if self.player.OB_mode_4_running == 1:
            print "bug 2 called in OB_Dice"
            self.hit_target(0)


    def hit_target(self, x):
        if (self.player.OB_mode_4_running == 1):
            nb = random.randint(1,6)
            self.machine.events.post('bug_splat_'+str(nb))
            self.player["score"] += (22220)
            self.turn_off_bug_light(x)
            self.set_bug_light(x)
            self.end_battle()


    def set_bug_light_state(self, x, state):
        self.targets_list[x]["state"] = state

    def set_bug_light(self, x):
        led = self.targets_list[x]["led"]
        state = self.targets_list[x]["state"]
        if state == 'blue':
            scp = self.machine.light_controller.registered_light_scripts["sc_blue_flash"]
            self.machine.light_controller.run_script(leds=led,script=scp ,priority=50, tocks_per_sec=80, key=led+"_"+state, blend=True)

    def turn_off_bug_light(self, x):
       print "turn off bug light"
       led = self.targets_list[x]["led"]
       state = self.targets_list[x]["state"]
       self.machine.light_controller.stop_script(led+"_"+state)
       self.machine.leds[led].color([10 ,10 ,10 ], 0, 0, 0, 1, 1) 


    def mode_stop(self, **kwargs):
        print 'OB_Dice mode_stop'
        self.end_battle()
