from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

class Doors(Mode):

    def mode_init(self):
        print 'Doors mode_init'

    def mode_start(self, **kwargs):
        print 'Doors mode_start'
        self.delay = DelayManager()
        if self.player.Doors_started == 0:
            #once per game only
            self.player.Doors_started = 1
            self.machine.game.player.doors_currentdoor = 0
            self.machine.game.player.doors_list = [
                {"led":"rgb_holiday_christmas", "state":1}
                ,{"led":"rgb_holiday_valentine", "state":0}
                ,{"led":"rgb_holiday_stpat", "state":0}
                ,{"led":"rgb_holiday_easter", "state":0}
                ,{"led":"rgb_holiday_independence", "state":0}
                ,{"led":"rgb_holiday_halloween", "state":0}
                ,{"led":"rgb_holiday_thanksgiving", "state":0}
                ,{"led":"rgb_holiday_door", "state":0}
                ]
        self.add_mode_event_handler('sw_slingl', self.rotate_doors)
        self.add_mode_event_handler('sw_slingr', self.rotate_doors)
        self.add_mode_event_handler('sw_hrampgate', self.trees_hit)
        self.add_mode_event_handler('holiday_mode_stopped', self.holiday_stopped)
        self.setup_scripts()
        self.set_door_lights()


    def set_door_lights(self):
#        print "Setting door lights"
        for x in range(0, 8):
            self.machine.light_controller.stop_script(key="holiday_"+str(x))
        for x in range(0, 8):
            state = self.machine.game.player.doors_list[x]["state"]
            led = self.machine.game.player.doors_list[x]["led"]
            print "Setting " + led + " to " + str(state)
            scp = self.machine.light_controller.registered_light_scripts[self.script[x][state]]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=80, tocks_per_sec=80, key="holiday_"+str(x), blend=True)


    def holiday_stopped(self, door=None, state=None, **kwargs):
        #state can be "complete" or "incomplete"
        cd = self.machine.game.player.doors_currentdoor 
        if state == "complete":
            self.machine.game.player.doors_list[cd]["state"] = 3 #completed
        else:
            self.machine.game.player.doors_list[cd]["state"] = 1 #back to ready
        self.machine.events.post('door_mode_'+str(cd)+'_stop')
        self.CycleDoors()
        self.set_door_lights()


    def rotate_doors(self, **kwargs):
        cd = self.machine.game.player.doors_currentdoor 
        state = self.machine.game.player.doors_list[cd]["state"]
        #only move the 'ready' door
        #cant move unlit, playing or solid doors
        if state == 1:  
            self.CycleDoors()
            self.set_door_lights()


    def trees_hit(self, **kwargs):
#        print 'Doors - tree gate'
        #don't start a holiday, if JACK is qualified 
        #and Char_what hasn't been played
        if not (self.player.Char_qualified == "Jack" and self.player.Char_what_state == 0):
            #if we just started Char_What, wait until a second has passed
            wstate = self.machine.game.player.Char_What_running
            if wstate <> 1 or (wstate == 1 and self.machine.game.player.Char_What_ticks < self.player.Char_What_base_ticks):
                cd = self.machine.game.player.doors_currentdoor 
                state = self.machine.game.player.doors_list[cd]["state"]
                #only start a 'ready' door
                if state == 1:  
                    self.StartHoliday()
                    self.set_door_lights()

    def StartHoliday(self):
        print 'Start Holiday'
        cd = self.machine.game.player.doors_currentdoor 
        self.machine.game.player.doors_list[cd]["state"] = 2 #playing
        self.machine.events.post('door_mode_'+str(cd)+'_start')


    def mode_stop(self, **kwargs):
        print 'Doors mode_stop'
        cd = self.machine.game.player.doors_currentdoor 
        state = self.machine.game.player.doors_list[cd]["state"]
        if state == 2:
            self.machine.game.player.doors_list[cd]["state"] = 1
        self.reset_door_lights()


    def reset_door_lights(self):
#        print "Setting door lights"
        for x in range(0, 8):
            self.machine.light_controller.stop_script(key="holiday_"+str(x))


    def CycleDoors(self):
        dcount = 0 
        done = 0
        t = 0
        CurrentDoor = self.machine.game.player.doors_currentdoor
        NewDoor = self.machine.game.player.doors_currentdoor

        while (dcount < 6) and (done == 0):
            NewDoor = NewDoor + 1
            if NewDoor > 6:
                NewDoor = 0
            ds = self.machine.game.player.doors_list[NewDoor]["state"]
            if ( ds == 0 ):
                #found next door, done
                self.machine.game.player.doors_list[NewDoor]["state"] = 1
                if self.machine.game.player.doors_list[CurrentDoor]["state"] == 1:
                    self.machine.game.player.doors_list[CurrentDoor]["state"] = 0
                done = 1
            dcount = dcount + 1
        if done == 0:
            # no next door?
            dcount = 0
            for t in range(0,7):
                if self.machine.game.player.doors_list[t]["state"] == 3: 
                    dcount = dcount + 1
            if dcount == 7:
                if self.machine.game.player.doors_list[7]["state"] == 3:
                    #if wizard mode was completed, reset 
                    #shut off lights
                    for t in range(0,7):
                        self.machine.game.player.doors_list[t]["state"] = 0
                    #select a random door
                    NewDoor = random.randint(0,6)
                    self.machine.game.player.doors_list[NewDoor]["state"] = 1
                else:               
                    #all at state 3 - then set to door 7, Wizard mode                
                    self.machine.game.player.doors_list[7]["state"] = 1
                    NewDoor = 7
        self.machine.game.player.doors_currentdoor = NewDoor


# 0 - off 1
# 1 - ready 1 (blink)
# 2 - MB 1
# 3 - completed 1
    def setup_scripts(self): 
        self.script = [[0 for x in range(8)] for x in range(8)] 
        self.script[0][0] = "sc_off"
        self.script[0][1] = "sc_christmas_ready"
        self.script[0][2] = "sc_christmas_playing"
        self.script[0][3] = "sc_christmas_done"

        self.script[1][0] = "sc_off"
        self.script[1][1] = "sc_valentines_ready"
        self.script[1][2] = "sc_valentines_playing"
        self.script[1][3] = "sc_valentines_done"

        self.script[2][0] = "sc_off"
        self.script[2][1] = "sc_stpats_ready"
        self.script[2][2] = "sc_stpats_playing"
        self.script[2][3] = "sc_stpats_done"

        self.script[3][0] = "sc_off"
        self.script[3][1] = "sc_easter_ready"
        self.script[3][2] = "sc_easter_playing"
        self.script[3][3] = "sc_easter_done"

        self.script[4][0] = "sc_off"
        self.script[4][1] = "sc_independence_ready"
        self.script[4][2] = "sc_independence_playing"
        self.script[4][3] = "sc_independence_done"

        self.script[5][0] = "sc_off"
        self.script[5][1] = "sc_halloween_ready"
        self.script[5][2] = "sc_halloween_playing"
        self.script[5][3] = "sc_halloween_done"

        self.script[6][0] = "sc_off"
        self.script[6][1] = "sc_thanksgiving_ready"
        self.script[6][2] = "sc_thanksgiving_playing"
        self.script[6][3] = "sc_thanksgiving_done"

        self.script[7][0] = "sc_off"
        self.script[7][1] = "sc_door_ready"
        self.script[7][2] = "sc_door_playing"
        self.script[7][3] = "sc_door_done"

