from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Door_Wizard
# Hinterlands Wizard Mode - "Holiday Rescue"                                                                                                                            Page 30
# 
# Brief Description
# Most major shots are lit to rescue holiday figures once shot enough times. 
# When a holiday figure is rescued you have to bring them back to the Hinterlands.
# 
# Scenario
# So it turns out that opening the doors in the Hinterlands may not've been such a good idea... 
# various holiday figures have ended up lost in various different worlds.
# Jack sends everyone out to help traverse the doors, find these important individuals, 
# and bring them back to the Hinterlands in order to return them to their realm.
# 
# Details
# This is a 4-ball multiball and you must keep all 4 balls going to get the best scores possible. 
# The ball saver is a generous 30 seconds when you start and can be manually triggered and reset 
# to 30 seconds a total of 3 times over the course of the multiball, each time simply by getting 
# a ball into the Graveyard. When this mode begins, 7 of the major shots are lit to rescue holiday figures. 
# The colour of the shot corresponds to the colour of the Hinterlands Door, so you know who you're
# rescuing. Of the 10 major shots, the ones not lit for rescues are Soup, Left Ramp and Graveyard. 
# As for all the other shots, to make a rescue, you simply need to hit the same shot three times. 
# When you do this, ALL other rescue shots go dark while the Left Ramp and Soup will both start flashing. 
# At this point, you can upgrade the jackpot shot into a super jackpot by getting a ball into soup, 
# then shooting the Hinterlands, but this upgrade only lasts 7 seconds, so you need to be quick. Once
# you get a ball into the Hinterlands, the holiday figure is rescued, you score a jackpot, and the 
# remaining rescues relight and reset to requiring 3 shots each. This means it's far more efficient to 
# go for the same shot three times in a row rather than to scatter shots all across the playfield, 
# since any progress you made on other rescues is lost once you're ready to rescue someone else. 
# If you get down to a single ball, any remaining ball saver triggers are lost and a 30 second timer 
# will show up. If you drain the last ball or the timer expires, the flippers die and the wizard mode ends, 
# returning the player to regular play following.
# 
# Scoring
# Rescue Jackpot                      2,500,000 (Multiplied by number of balls in play)
# Rescue Jackpot Increase             1,250,000
# Super Jackpot                       3x Jackpot Value
# 
# Lighting
# Holiday figures to rescue will flash the triangle of their shots with the appropriate Hinterlands door colour. 
# When that holiday figure is rescued, the Hinterlands shot will flash its triangle the appropriate colour. 
# The Graveyard shot alternates its triangle between orange and white to indicate that it will trigger the ball saver. 
# The soup shot alternates its triangle between white and the appropriate colour to indicate when it will upgrade 
# the jackpot to a super jackpot. Super jackpots on the Hinterlands shot will flash both the triangle and circle.
# 
# Difficulty Adjustments
# Very Easy  5 Balls, Each Shot Needs to be Hit 2 Times for Rescue, Ball Saver Time is 40 Seconds, Can Re-Trigger Ball Saver 4 Times
# Easy       4 Balls, Each Shot Needs to be Hit 3 Times for Rescue, Ball Saver Time is 30 Seconds, Can Re-Trigger Ball Saver 4 Times
# Normal     4 Balls, Each Shot Needs to be Hit 3 Times for Rescue, Ball Saver Time is 30 Seconds, Can Re-Trigger Ball Saver 3 Times
# Hard       4 Balls, Each Shot Needs to be Hit 4 Times for Rescue, Ball Saver Time is 30 Seconds, Can Re-Trigger Ball Saver 3 Times
# Very Hard  3 Balls, Each Shot Needs to be Hit 4 Times for Rescue, Ball Saver Time is 25 Seconds, Can Re-Trigger Ball Saver 2 Times

class Door_Wizard(Mode):

    def mode_init(self):
        print 'Door_Wizard mode_init'

    def mode_start(self, **kwargs):
        print 'Door_Wizard mode_start'
        self.delay = DelayManager()

    def mode_stop(self, **kwargs):
        print 'Door_Wizard mode_stop'
