from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Door_Valentines 
# Hinterlands Door Mode - "Love is in the Air"
# 
# Brief Description
# You must get a certain number of points off the spinner. 
# To help out, the more lit shots you clear the more valuable the spinner gets.
# 
# Scenario
# Cupid is out and about in Halloween Town trying to figure out how to make 
# the denizens fall in love. He figures just shoot as many arrows as he can!
# 
# Details
# The goal of this mode is to score 5,000,000 points off of the spinner alone within 45 seconds. 
# However, the base value of the spinner in this mode is only 10,000,
# thus without a shot multiplier this would take 500 spins. However, all of the other 
# major shots and many of the standups (JACK, Doctor, LSB and Mystery) start
# flashing pink at a moderate speed. When you hit one of these flashing shots 
# or standups it will unlight and increase the spinner value. The idea is to hit lots of
# different things to get the spinner value up, then go for spinner shots to clear the 
# 5,000,000 much more easily! The spinner value will double if all 17 of the pink shots
# are cleared!
# 
# Scoring
# Base Spinner Value                         10,000 / spin
# Increase per Shot/Standup Cleared          25,000 / spin
# Maximum Potential Spinner Value            870,000 / spin (425,000+10,000) x2 for having all 17 pink shots cleared)
# 
# Lighting
# The spinner will flash yellow on the triangle for most of the mode 
# but will flash a white triangle and circle if all 17 pink shots are cleared. 
# Each shot lit to increase the spinner value will flash pink.
# 
# Difficulty Adjustments
# Very Easy         60 Seconds, Target Score of 3,000,000
# Easy              50 Seconds, Target Score of 4,000,000
# Normal            45 Seconds, Target Score of 5,000,000
# Hard              40 Seconds, Target Score of 6,000,000
# Very Hard         35 Seconds, Target Score of 7,000,000

class Door_Valentines(Mode):

    def mode_init(self):
        print 'Door_Valentines mode_init'

    def mode_start(self, **kwargs):
        print 'Door_Valentines mode_start'
        self.delay = DelayManager()
        self.ticks = 0
        if self.player.door_valentines_started == 0:
            #once per game only
            self.player.door_valentines_started = 1
            self.player.door_valentines_running = 0
        self.player.door_valentines_spin_score = 0
        self.player.door_valentines_spin_value = 0
        self.player.door_valentines_ticks = 90  #90 = 45 seconds
        self.player.door_valentines_spin_value_pts = 10000
        self.player.door_valentines_score_needed = 5000000
        self.machine.game.player.door_valentines_shotlist = [
            {"led":"rgb_mayor_arrow", "state":"off"}
#            ,{"led":"rgb_lorbit_arrow", "state":"off"}
            ,{"led":"rgb_lramp_arrow", "state":"off"}
            ,{"led":"rgb_leftloop_arrow", "state":"off"}
            ,{"led":"rgb_oogie_cw_arrow", "state":"off"}
            ,{"led":"rgb_oogie_ccw_arrow", "state":"off"}
            ,{"led":"rgb_grave_arrow", "state":"off"}
            ,{"led":"rgb_rramp_arrow", "state":"off"}
            ,{"led":"rgb_rorbit_arrow", "state":"off"}
            ,{"led":"rgb_soup_arrow", "state":"off"}
            ,{"led":"rgb_lramp_ldiamond", "state":"off"}
            ,{"led":"rgb_lramp_rdiamond", "state":"off"}
            ,{"led":"rgb_lock_rect", "state":"off"}
            ,{"led":"rgb_shock_rect", "state":"off"}
            ,{"led":"rgb_barrel_rect", "state":"off"}
#            ,{"led":"rgb_bug_1", "state":"off"}
#            ,{"led":"rgb_bug_2", "state":"off"}
#            ,{"led":"rgb_bug_3", "state":"off"}
            ,{"led":"rgb_mystery_rect", "state":"off"}
            ,{"led":"rgb_rramp_ldiamond", "state":"off"}
            ,{"led":"rgb_rramp_rdiamond", "state":"off"}
            ,{"led":"rgb_doctor_rect", "state":"off"}

            ,{"led":"rgb_lorbit_arrow", "state":"off"}
            ,{"led":"rgb_lorbit_circle", "state":"off"}
            ]
        self.add_mode_event_handler('sw_sally', self.spin)
        self.add_mode_event_handler("major_0_singlestep_unlit_hit", self.major_0)
#        self.add_mode_event_handler("major_1_singlestep_unlit_hit", self.major_1)
        self.add_mode_event_handler("major_2_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_2a_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_3_singlestep_unlit_hit", self.major_3)
        self.add_mode_event_handler("major_4_singlestep_unlit_hit", self.major_4)
        self.add_mode_event_handler("major_5_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_5a_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_6_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_6a_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_7_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_7a_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_8_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_8a_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_9_singlestep_unlit_hit", self.major_9)
        self.add_mode_event_handler('sw_bugbashtarget1', self.bug_hit1)
        self.add_mode_event_handler('sw_bugbashtarget2', self.bug_hit2)
        self.add_mode_event_handler('sw_bugbashtarget3', self.bug_hit3)
        self.add_mode_event_handler('sw_bugbashtarget4', self.bug_hit4)
        self.add_mode_event_handler('sw_bugbashtarget5', self.bug_hit5)
#        self.add_mode_event_handler('sw_bugbashtarget6', self.bug_hit6)
#        self.add_mode_event_handler('sw_bugbashtarget7', self.bug_hit7)
#        self.add_mode_event_handler('sw_bugbashtarget8', self.bug_hit8)
        self.add_mode_event_handler('sw_bugbashtarget9', self.bug_hit9)
        self.add_mode_event_handler('sw_bugbashtarget10', self.bug_hit10)
        self.add_mode_event_handler('sw_bugbashtarget11', self.bug_hit11)
        self.add_mode_event_handler('sw_bugbashtarget12', self.bug_hit12)
        self.valentines_start()

    def valentines_start(self):
        print "holiday valentines start"
        if (self.player.door_valentines_running == 0):
            self.player.door_valentines_ticks = 90  #90 = 45 seconds
            self.player.door_valentines_spin_value_pts = 10000
            self.player.door_valentines_score_needed = 5000000
            self.player.door_valentines_spin_score = 0
            self.player.door_valentines_spin_value = 0
            self.set_shots()
            self.player.door_valentines_running = 1
            self.machine.events.post("holiday_valentines_music_start")
            self.ticks = self.player.door_valentines_ticks 
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="holiday_valentines_ticker", ms=delaytime, callback=self.ticker)

    def ticker(self):
        print "Door_Valentines - 500ms tick"
        self.timeleft = int(self.ticks/2)
        self.machine.events.post("holiday_valentines_countdown", value=self.timeleft)
        self.ticks -= 1;
        if self.ticks <= 0:
            self.valentines_stop()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="holiday_valentines_ticker", ms=delaytime, callback=self.ticker)

    def valentines_stop(self):
        if self.machine.game.player.door_valentines_running == 1:
            self.machine.events.post('holiday_valentines_music_stop')
            print "holiday valentines over"
            if self.player.door_valentines_spin_score >= self.player.door_valentines_score_needed:
                self.machine.events.post('holiday_mode_stopped', state="complete")
                self.machine.game.player.door_valentines_running = 2 #completed
            else:
                self.machine.events.post('holiday_mode_stopped', state="incomplete")
                self.machine.game.player.door_valentines_running = 0 #ready to start again
            self.reset_shots()


    def set_shots(self):
        for x in range(0, 19):
            self.machine.game.player.door_valentines_shotlist[x]["state"] = "pink_flash"
        self.machine.game.player.door_valentines_shotlist[18]["state"] = "yellow_flash"
        self.machine.game.player.door_valentines_shotlist[19]["state"] = "yellow_flash"
        self.set_shot_lights()


    def set_shot_lights(self):
        for x in range(0, 20):
            self.machine.light_controller.stop_script(key="holiday_valentines_"+str(x))
        for x in range(0, 20):
            state = self.machine.game.player.door_valentines_shotlist[x]["state"]
            led = self.machine.game.player.door_valentines_shotlist[x]["led"]
            script_name = "sc_"+state
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=40, tocks_per_sec=80, key="holiday_valentines_"+str(x), blend=True)


    def major_0(self, **kwargs):
        self.handle_shot(0)
#    def major_1(self, **kwargs):
#        self.handle_shot(1)
    def major_2(self, **kwargs):
        self.handle_shot(1)
    def major_3(self, **kwargs):
        self.handle_shot(2)
    def major_4(self, **kwargs):
        self.handle_shot(3)
    def major_5(self, **kwargs):
        self.handle_shot(4)
    def major_6(self, **kwargs):
        self.handle_shot(5)
    def major_7(self, **kwargs):
        self.handle_shot(6)
    def major_8(self, **kwargs):
        self.handle_shot(7)
    def major_9(self, **kwargs):
        self.handle_shot(8)
    def bug_hit1(self, **kwargs):
        self.handle_shot(9)
    def bug_hit2(self, **kwargs):
        self.handle_shot(10)
    def bug_hit3(self, **kwargs):
        self.handle_shot(11)
    def bug_hit4(self, **kwargs):
        self.handle_shot(12)
    def bug_hit5(self, **kwargs):
        self.handle_shot(13)
#    def bug_hit6(self, **kwargs):
#        self.handle_shot(14)
#    def bug_hit7(self, **kwargs):
#        self.handle_shot(15)
#    def bug_hit8(self, **kwargs):
#        self.handle_shot(16)
    def bug_hit9(self, **kwargs):
        self.handle_shot(14)
    def bug_hit10(self, **kwargs):
        self.handle_shot(15)
    def bug_hit11(self, **kwargs):
        self.handle_shot(16)
    def bug_hit12(self, **kwargs):
        self.handle_shot(17)


    def handle_shot(self, shot):
        if self.machine.game.player.door_valentines_running == 1:
            if self.machine.game.player.door_valentines_shotlist[shot]["state"] == "pink_flash":
                self.player.door_valentines_spin_value += 1
                self.machine.game.player.door_valentines_shotlist[shot]["state"] = "off"
                if self.player.door_valentines_spin_value == 17:
                    self.machine.game.player.door_valentines_shotlist[18]["state"] = "white_flash"
                    self.machine.game.player.door_valentines_shotlist[19]["state"] = "white_flash"
                self.set_shot_lights()
                #calc how much each spin is worth
                self.score = 10000+self.player.door_valentines_spin_value*25000
                self.score *= self.player.multiplier_shot_value_list[1] # 1X, 2X or 3X 
                if self.player.door_valentines_spin_value == 17:
                    self.score *= 2   #2X if all 17 pink targets are hit
#                self.machine.events.post('valentines_spin_value_increased', 
#                    value=self.score )
                self.player.door_valentines_spin_value_pts = self.score


    def spin(self, **kwargs):
        if self.machine.game.player.door_valentines_running == 1:
            self.score = 10000+self.player.door_valentines_spin_value*25000
            self.score *= self.player.multiplier_shot_value_list[1] # 1X, 2X or 3X 
            if self.player.door_valentines_spin_value == 17:
                self.score *= 2   #2X if all 17 pink targets are hit
            self.player.door_valentines_spin_score += self.score
            self.machine.events.post('valentines_spin_score_increased', 
                    value=self.player.door_valentines_spin_score )

    def reset_shots(self):
        for x in range(0, 20):
            self.machine.game.player.door_valentines_shotlist[x]["state"] = "off"
        self.set_shot_lights()


    def mode_stop(self, **kwargs):
        print 'Door_Valentines mode_stop'
        self.valentines_stop()
        self.reset_shots()
