from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Door_Thanksgiving  
# Hinterlands Door Mode - "Harvest Frenzy"
# 
# Brief Description
# This mode is like an inverse frenzy: 
# Only one shot scores the frenzy value, but all other switches increases it.
# 
# Scenario
# A turkey has found its way to the edge of Halloween Town... 
# which prompts everyone to go nuts and start collecting all kinds of food!
# 
# Details
# While this mode is running, the soup shot will score the frenzy value, 
# which starts at 250,000. Every switch hit increases this value by 25,000. 
# You can collect the frenzy value as many time as you want within the time limit. 
# The ultimate goal is to score 2,500,000 points in total from the frenzy value.
# 
# Scoring
# Base Frenzy Value                         250,000
# Frenzy Value Increase per Switch          25,000
# 
# Lighting
# The soup shot will flash a white triangle and circle.
# 
# Difficulty Adjustments
# Very Easy        60 Second Time Limit, 1,500,000 Points to Complete
# Easy             50 Second Time Limit, 2,000,000 Points to Complete
# Normal           45 Second Time Limit, 2,500,000 Points to Complete
# Hard             40 Second Time Limit, 3,000,000 Points to Complete
# Very Hard        35 Second Time Limit, 3,500,000 Points to Complete                                                                                                                      Page 31

class Door_Thanksgiving(Mode):

    def mode_init(self):
        print 'Door_Thanksgiving mode_init'


    def mode_start(self, **kwargs):
        print 'Door_thanksgiving mode_start'
        self.delay = DelayManager()
        self.ticks = 0
        self.player.door_thanksgiving_running = 0
        self.player.door_thanksgiving_soup_score = 0
        self.player.door_thanksgiving_soup_value = 250000
        self.player.door_thanksgiving_ticks = 90  #90 = 45 seconds
        self.player.door_thanksgiving_score_needed = 2500000
        self.machine.game.player.door_thanksgiving_shotlist = [
             {"led":"rgb_lramp_ldiamond", "state":"off"}
            ,{"led":"rgb_lramp_rdiamond", "state":"off"}
            ,{"led":"rgb_lock_rect", "state":"off"}
            ,{"led":"rgb_shock_rect", "state":"off"}
            ,{"led":"rgb_barrel_rect", "state":"off"}
            ,{"led":"rgb_bug_1", "state":"off"}
            ,{"led":"rgb_bug_2", "state":"off"}
            ,{"led":"rgb_bug_3", "state":"off"}
            ,{"led":"rgb_rramp_ldiamond", "state":"off"}
            ,{"led":"rgb_rramp_rdiamond", "state":"off"}
            ,{"led":"rgb_doctor_rect", "state":"off"}
            ,{"led":"rgb_lorbit_arrow", "state":"off"}
            ,{"led":"rgb_soup_arrow", "state":"off"}
            ]
        self.add_mode_event_handler('sw_bugbashtarget1', self.bug_hit1)
        self.add_mode_event_handler('sw_bugbashtarget2', self.bug_hit2)
        self.add_mode_event_handler('sw_bugbashtarget3', self.bug_hit3)
        self.add_mode_event_handler('sw_bugbashtarget4', self.bug_hit4)
        self.add_mode_event_handler('sw_bugbashtarget5', self.bug_hit5)
        self.add_mode_event_handler('sw_bugbashtarget6', self.bug_hit6)
        self.add_mode_event_handler('sw_bugbashtarget7', self.bug_hit7)
        self.add_mode_event_handler('sw_bugbashtarget8', self.bug_hit8)
        self.add_mode_event_handler('sw_bugbashtarget10', self.bug_hit10)
        self.add_mode_event_handler('sw_bugbashtarget11', self.bug_hit11)
        self.add_mode_event_handler('sw_bugbashtarget12', self.bug_hit12)
        self.add_mode_event_handler('sw_sally', self.spin)
        self.add_mode_event_handler("major_9_singlestep_unlit_hit", self.soup)
        self.thanksgiving_start()

    def thanksgiving_start(self):
        print "holiday thanksgiving start"
        if (self.player.door_thanksgiving_running == 0):
            self.player.door_thanksgiving_ticks = 90  #90 = 45 seconds
            self.player.door_thanksgiving_soup_value = 250000
            self.player.door_thanksgiving_score_needed = 2500000
            self.player.door_thanksgiving_soup_score = 0
            self.set_shots()
            self.player.door_thanksgiving_running = 1
            self.machine.events.post("holiday_thanksgiving_music_start")
            self.ticks = self.player.door_thanksgiving_ticks 
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="holiday_thanksgiving_ticker", ms=delaytime, callback=self.ticker)

    def ticker(self):
        print "Door_thanksgiving - 500ms tick"
        self.player.door_thanksgiving_timeleft = int(self.ticks/2)
        self.machine.events.post("holiday_thanksgiving_countdown")
        self.ticks -= 1;
        if self.ticks <= 0:
            self.thanksgiving_stop()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="holiday_thanksgiving_ticker", ms=delaytime, callback=self.ticker)

    def thanksgiving_stop(self):
        if self.machine.game.player.door_thanksgiving_running == 1:
            self.machine.events.post('holiday_thanksgiving_music_stop')
            print "holiday thanksgiving over"
            if self.player.door_thanksgiving_soup_score >= self.player.door_thanksgiving_score_needed:
                self.machine.events.post('holiday_mode_stopped', state="complete")
                self.machine.game.player.door_thanksgiving_running = 2 #completed
            else:
                self.machine.events.post('holiday_mode_stopped', state="incomplete")
                self.machine.game.player.door_thanksgiving_running = 0 #ready to start again
            self.reset_shots()


    def set_shots(self):
        for x in range(0, 11):
            self.machine.game.player.door_thanksgiving_shotlist[x]["state"] = "yellow_flash"
        self.set_shot_lights()


    def set_shot_lights(self):
        for x in range(0, 11):
            self.machine.light_controller.stop_script(key="holiday_thanksgiving_"+str(x))
        for x in range(0, 11):
            state = self.machine.game.player.door_thanksgiving_shotlist[x]["state"]
            led = self.machine.game.player.door_thanksgiving_shotlist[x]["led"]
            script_name = "sc_"+state
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=40, tocks_per_sec=80, key="holiday_thanksgiving_"+str(x), blend=True)


    def bug_hit1(self, **kwargs):
        self.handle_shot(0)
    def bug_hit2(self, **kwargs):
        self.handle_shot(1)
    def bug_hit3(self, **kwargs):
        self.handle_shot(2)
    def bug_hit4(self, **kwargs):
        self.handle_shot(3)
    def bug_hit5(self, **kwargs):
        self.handle_shot(4)
    def bug_hit6(self, **kwargs):
        self.handle_shot(5)
    def bug_hit7(self, **kwargs):
        self.handle_shot(6)
    def bug_hit8(self, **kwargs):
        self.handle_shot(7)
    def bug_hit10(self, **kwargs):
        self.handle_shot(8)
    def bug_hit11(self, **kwargs):
        self.handle_shot(9)
    def bug_hit12(self, **kwargs):
        self.handle_shot(10)
        
    def spin(self, **kwargs):
        self.handle_shot(11)


    def handle_shot(self, shot):
        if self.machine.game.player.door_thanksgiving_running == 1:
            self.machine.game.player.door_thanksgiving_shotlist[shot]["state"] = "orange_flash"
            self.set_shot_lights()
            self.player.door_thanksgiving_soup_value += 25000
            self.machine.events.post('thanksgiving_soup_value_increased', 
                    value=self.player.door_thanksgiving_soup_value )


    def soup(self, **kwargs):
        if self.machine.game.player.door_thanksgiving_running == 1:
            self.score = self.player.door_thanksgiving_soup_value
            self.score *= self.player.multiplier_shot_value_list[9] # 1X, 2X or 3X 
            self.player.door_thanksgiving_soup_score += self.score
            self.player.score += self.score
            self.machine.events.post('thanksgiving_soup_score_increased', 
                    value=self.player.door_thanksgiving_soup_score )

    def reset_shots(self):
        for x in range(0, 11):
            self.machine.game.player.door_thanksgiving_shotlist[x]["state"] = "off"
        self.set_shot_lights()


    def mode_stop(self, **kwargs):
        print 'Door_thanksgiving mode_stop'
        self.thanksgiving_stop()
        self.reset_shots()

