from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Door_StPatricks    
# Hinterlands Door Mode - "Pot o' Gold"
# 
# Brief Description
# Shoot to the Hinterlands to collect the Pot o' Gold value 
# and complete the mode, but the value should be built up by the pop bumpers first.
# 
# Scenario
# A leprechaun has snuck into Halloween Town. More specifically, into a 
# cash vault in Oogie Boogie's Lair. He must collect as much gold for his pot as he can and get
# back home before he gets caught!
# 
# Details
# All you have to do to complete this timed mode is shoot the ball back into the Hinterlands, 
# which will collect the score for this mode. However, when the mode starts,
# this shot is only worth 100,000. Each pop bumper hit adds another 100,000 to this value 
# with no cap, thus the idea is to collect as many pop bumper hits as you feel
# safe to, then shoot for the Hinterlands. The pop-up post to divert to the pops will fire 
# on orbit shots for the duration of this mode.
# 
# Scoring
# Base Left Ramp Value              100,000
# Left Ramp Increase per Pop        100,000
# 
# Lighting
# The pop bumpers will be flashing yellow during this mode while the 
# Hinterlands shot will flash both its triangle and circle yellow.
# 
# Difficulty Adjustments
# Very Easy         40 Second Time Limit
# Easy              35 Second Time Limit
# Normal            30 Second Time Limit
# Hard              25 Second Time Limit
# Very Hard         20 Second Time Limit

class Door_StPatricks(Mode):

    def mode_init(self):
        print 'Door_StPatricks mode_init'

    def mode_start(self, **kwargs):
        print 'Door_StPatricks mode_start'
        self.delay = DelayManager()
        self.ticks = 90  #90 = 45 seconds
        self.player.door_stpatricks_running = 0
        self.player.door_stpatricks_ramp_score = 0
        self.player.door_stpatricks_ticks = 90  #90 = 45 seconds
        self.player.door_stpatricks_ramp_value = 100000
        self.add_mode_event_handler("major_2_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_2a_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler('sw_bumpertop', self.pophit)
        self.add_mode_event_handler('sw_bumperleft', self.pophit)
        self.add_mode_event_handler('sw_bumperright', self.pophit)
        self.stpatricks_start()


    def stpatricks_start(self):
        print "holiday stpatricks start"
        if (self.player.door_stpatricks_running == 0):
            self.player.door_stpatricks_ticks = 90  #90 = 45 seconds
            self.player.door_stpatricks_ramp_value = 100000
            self.player.door_stpatricks_ramp_score = 0
            self.player.door_stpatricks_running = 1
            self.machine.events.post("holiday_stpatricks_music_start")
            self.ticks = self.player.door_stpatricks_ticks 
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="holiday_stpatricks_ticker", ms=delaytime, callback=self.ticker)
            self.set_lights()
            self.machine.events.post('popuppost_enable_up')

    def ticker(self):
        print "Door_stpatricks - 500ms tick"
        self.timeleft = int(self.ticks/2)
        self.machine.events.post("holiday_stpatricks_countdown", value=self.timeleft)
        self.ticks -= 1;
        if self.ticks <= 0:
            self.stpatricks_stop()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="holiday_stpatricks_ticker", ms=delaytime, callback=self.ticker)

    def stpatricks_stop(self):
        if self.machine.game.player.door_stpatricks_running == 1:
            self.machine.events.post('holiday_stpatricks_music_stop')
            print "holiday stpatricks over"
            if self.player.door_stpatricks_ramp_score >= 0:
                self.machine.events.post('holiday_mode_stopped', state="complete")
                self.machine.game.player.door_stpatricks_running = 2 #completed
            else:
                self.machine.events.post('holiday_mode_stopped', state="incomplete")
                self.machine.game.player.door_stpatricks_running = 0 #ready to start again
            self.reset_lights()
            self.machine.events.post('popuppost_disable_up')


    def major_2(self,**kwargs):
        if self.machine.game.player.door_stpatricks_running == 1:
            print "Door_stpatricks - ramp"
            self.score = self.player.door_stpatricks_ramp_value
            self.score *= self.player.multiplier_shot_value_list[2] # 1X, 2X or 3X 
            self.player.door_stpatricks_ramp_score += self.score
            self.machine.events.post('stpatricks_ramp_score_increased', 
                    value=self.player.door_stpatricks_ramp_score )
    
        
    def pophit(self,**kwargs):
        print "Door_stpatricks - pop hit"
        if self.machine.game.player.door_stpatricks_running == 1:
            self.player.door_stpatricks_ramp_value += 100000
            self.machine.events.post('stpatricks_ramp_value_increased', 
                    value=self.player.door_stpatricks_ramp_value )
    
    def set_lights(self):
        led = "rgb_lramp_arrow"
        script_name = "sc_green_flash"
        scp = self.machine.light_controller.registered_light_scripts[script_name]
        self.machine.light_controller.run_script(leds=led, script=scp, priority=40, tocks_per_sec=80, key="stpatricks_arrow1", blend=True)
        led = "rgb_lorbit_arrow"
        script_name = "sc_green_flash"
        scp = self.machine.light_controller.registered_light_scripts[script_name]
        self.machine.light_controller.run_script(leds=led, script=scp, priority=40, tocks_per_sec=80, key="stpatricks_arrow2", blend=True)
        led = "rgb_rorbit_arrow"
        script_name = "sc_green_flash"
        scp = self.machine.light_controller.registered_light_scripts[script_name]
        self.machine.light_controller.run_script(leds=led, script=scp, priority=40, tocks_per_sec=80, key="stpatricks_arrow3", blend=True)


    def reset_lights(self):
        self.machine.light_controller.stop_script(key="stpatricks_arrow1")
        self.machine.light_controller.stop_script(key="stpatricks_arrow2")
        self.machine.light_controller.stop_script(key="stpatricks_arrow3")                
        led = "rgb_lorbit_arrow"
        script_name = "sc_off"
        scp = self.machine.light_controller.registered_light_scripts[script_name]
        self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=80, key="stpatricks_arrow", repeat=0, blend=True)
        led = "rgb_lorbit_arrow"
        script_name = "sc_off"
        scp = self.machine.light_controller.registered_light_scripts[script_name]
        self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=80, key="stpatricks_arrow2", blend=True)
        led = "rgb_rorbit_arrow"
        script_name = "sc_off"
        scp = self.machine.light_controller.registered_light_scripts[script_name]
        self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=80, key="stpatricks_arrow3", blend=True)
    
    
    def mode_stop(self, **kwargs):
        print 'Door_StPatricks mode_stop'
        self.stpatricks_stop()
        
        