from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Hinterlands Door Mode - "Trick or Treat!"                                                                                                                       Page 27
# 
# Brief Description
# You must complete the LSB standup bank as many time as you can without hitting the Doctor Finklestein standup.
# 
# Scenario
# Lock, Shock and Barrel are out trick-or-treating. Everyone in Halloween Town is a good sport about it, 
# but Doctor Finklestein is in the middle of a critical experiment, so disturbing him would be a really bad idea...
# 
# Details
# Unlike all the other single-ball modes in this game, this one is not timed, however, 
# hitting Doctor Finklestein immediately ends the mode. The trick is to complete the LSB standups 
# as many times as you can without hitting Doctor Finklestein. You only have to complete the bank 
# twice to complete the mode, but can then continue for as many completions as you want as the value 
# increases with each completion.
# 
# Scoring
# Lock, Shock or Barrel Standup              20,000
# Base LSB Completion Value                  1,000,000
# Completion Value Increase                  500,000
# Completion Value Cap                       5,000,000
# Doctor Finklestein                         10
# 
# Lighting
# Doctor Finklestein is solid red for the duration of the mode while the LSB targets flash yellow 
# when ready to hit and go solid yellow once hit. The LSB targets rapidly
# flash white each time they're completed.
# 
# Difficulty Adjustments
# Very Easy        1 LSB Completion Completes Mode, Doctor Finklestein must be hit twice to end the mode
# Easy             1 LSB Completion Completes Mode
# Normal           2 LSB Completions Completes Mode
# Hard             2 LSB Completions Completes Mode
# Very Hard        3 LSB Completions Completes Mode

class Door_Halloween(Mode):

    def mode_init(self):
        print 'Door_Halloween mode_init'

    def mode_start(self, **kwargs):
        print 'Door_Halloween mode_start'
        self.delay = DelayManager()
        if self.player.door_halloween_started == 0:
            #once per game only
            self.player.door_halloween_started = 1
        self.player.door_halloween_running = 0
        self.player.door_halloween_LSB_value = 100000
        self.player.door_halloween_LSB_score = 0
        self.player.door_halloween_LSB_completed = 0
        self.player.door_halloween_LSB_completed_needed = 1
        self.player.door_halloween_Doctor = 0
        self.add_mode_event_handler('sw_mystery', self.halloween_stop)
        self.add_mode_event_handler('sw_lock', self.lock_hit)
        self.add_mode_event_handler('sw_shock', self.shock_hit)
        self.add_mode_event_handler('sw_barrel', self.barrel_hit)
        self.add_mode_event_handler("lsb_standups_lsbp_lit_complete", self.lsb_complete)        
        self.add_mode_event_handler('sw_doctor', self.doctor_hit)
        self.halloween_start()
        
        
    def halloween_start(self):
        print "holiday halloween start"
        if (self.player.door_halloween_running == 0):
            self.player.door_halloween_running = 1
            self.machine.events.post("holiday_halloween_music_start")
            self.player.door_halloween_LSB_value = 100000
            self.player.door_halloween_LSB_score = 0
            self.player.door_halloween_LSB_completed = 0
            self.player.door_halloween_Doctor = 2 #2 hits and its over
            self.set_lights()

    def halloween_stop(self, **kwargs):
        if self.machine.game.player.door_halloween_running == 1:
            self.machine.events.post('holiday_halloween_music_stop')
            print "holiday halloween over"
            if self.player.door_halloween_LSB_completed >= self.player.door_halloween_LSB_completed_needed:
                self.machine.game.player.door_halloween_running = 2
                self.machine.events.post('holiday_mode_stopped', state="complete")            
            else:
                self.machine.game.player.door_halloween_running = 0 #ready to start again
                self.machine.events.post('holiday_mode_stopped', state="incomplete")
            self.reset_lights()
            
    def set_lights(self):
        led = "rgb_doctor_rect"
        script_name = "sc_red_flash"
        scp = self.machine.light_controller.registered_light_scripts[script_name]
        self.machine.light_controller.run_script(leds=led, script=scp, priority=40, tocks_per_sec=80, key="halloween_doctor", blend=True)

    def reset_lights(self):
        self.machine.light_controller.stop_script(key="halloween_doctor")
        led = "rgb_doctor_rect"
        script_name = "sc_off"
        scp = self.machine.light_controller.registered_light_scripts[script_name]
        self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=80, key="halloween_doctor", repeat=0, blend=True)

    def lsb_complete(self,**kwargs):
        if self.machine.game.player.door_halloween_running == 1:
            print "door_halloween - LSB complete"
            self.player.door_halloween_LSB_completed += 1
            score = self.player.door_halloween_LSB_value
            self.player.door_halloween_LSB_score += score
            self.machine.events.post('door_halloween_LSB_completed', 
                    value=self.player.door_halloween_LSB_value,
                    score=score)
            self.player.score += score

    def lock_hit(self, **kwargs):
        print "Door_Halloween - lock hit"

    def shock_hit(self, **kwargs):
        print "Door_Halloween - shock hit"

    def barrel_hit(self, **kwargs):
        print "Door_Halloween - barrel hit"

    def doctor_hit(self, **kwargs):
        print "Door_Halloween - doctor hit"
        if self.machine.game.player.door_halloween_running == 1:        
            self.player.door_halloween_Doctor -= 1
            if self.player.door_halloween_Doctor <= 0:
                #mode is over!
                self.halloween_stop()
                self.machine.events.post('door_halloween_doctor_hit_done')
            else:
                self.machine.events.post('door_halloween_doctor_hit')
        
    def mode_stop(self, **kwargs):
        print 'Door_Halloween mode_stop'
        if self.machine.game.player.door_halloween_running == 1:        
            self.halloween_stop()
