from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Hinterlands Door Mode - "Easter Egg Hunt"                                                                                                                           Page 25
# 
# Brief Description
# All the major shots are lit for various values, but the values are assigned at random 
# from a pool of values. Once you know the value of a shot you can continue to
# shoot it to score those points over and over. You must uncover at least three 
# different values to complete the mode.
# 
# Scenario
# The Easter Bunny has hidden a whole bunch of eggs all over Halloween Town. Find them!
# 
# Details
# All ten major shots will flash solid white when this mode begins. 
# Each major shot will also have a value hidden within it. There are ten values to assign thus they are
# shuffled and distributed between all shots. There are 4x "50,000" values, 
# 2x "100,000" values, 2x "250,000" values, 1x "500,000" and 1x "1,000,000". 
# When you make a shot it will change colour to indicate how good of a shot it is. 
# You can then go for that shot as much as you want within the 30 second time limit. 
# Once you've unveiled three different shots, the mode is complete and all other unveiled shots will go out, 
# but until the mode timer expires you can continue to shoot the shots
# you've uncovered to score more points from them.
# 
# Scoring
# Shot Values                50,000 / 100,000 / 250,000 / 500,000 / 1,000,000
# 
# Lighting
# Major shot triangles will all flash white at first. Once a shot value is unveiled it will be 
# red for 50,000, 
# orange for 100,000, 
# yellow for 250,000, 
# green for 500,000 and
# blue for 1,000,000.
# 
# Difficulty Adjustments
# Very Easy        40 Second Time Limit
# Easy             35 Second Time Limit
# Normal           30 Second Time Limit
# Hard             25 Second Time Limit
# Very Hard        20 Second Time Limit

class Door_Easter(Mode):

    def mode_init(self):
        print 'Door_Easter mode_init'

    def mode_start(self, **kwargs):
        print 'Door_Easter mode_start'
        self.delay = DelayManager()
        if self.player.door_easter_started == 0:
            self.player.door_easter_started = 1
            self.player.door_easter_running = 0
        self.ticks = 0
        self.player.door_easter_base_ticks = 90  #90 = 45 seconds
        self.player.door_easter_ticks = 0
        self.player.door_easter_shots_needed = 3
        self.player.door_easter_score = 0
        self.player.door_easter_shots_revealed = 0
        self.player.door_easter_shot_pool = [1000000,
                500000,
                250000,250000, 
                100000,100000, 
                50000,50000,
                50000,50000]
        self.player.door_easter_shot_value = [0,0,0,0,0,0,0,0,0,0]        
        self.machine.game.player.door_easter_shotlist = [
            {"led":"rgb_mayor_arrow", "state":"off"}
            ,{"led":"rgb_lorbit_arrow", "state":"off"}
            ,{"led":"rgb_lramp_arrow", "state":"off"}
            ,{"led":"rgb_leftloop_arrow", "state":"off"}
            ,{"led":"rgb_oogie_cw_arrow", "state":"off"}
            ,{"led":"rgb_oogie_ccw_arrow", "state":"off"}
            ,{"led":"rgb_grave_arrow", "state":"off"}
            ,{"led":"rgb_rramp_arrow", "state":"off"}
            ,{"led":"rgb_rorbit_arrow", "state":"off"}
            ,{"led":"rgb_soup_arrow", "state":"off"}
            ]
        self.add_mode_event_handler("major_0_singlestep_unlit_hit", self.major_0)
        self.add_mode_event_handler("major_1_singlestep_unlit_hit", self.major_1)
        self.add_mode_event_handler("major_2_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_2a_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_3_singlestep_unlit_hit", self.major_3)
        self.add_mode_event_handler("major_4_singlestep_unlit_hit", self.major_4)
        self.add_mode_event_handler("major_5_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_5a_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_6_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_6a_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_7_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_7a_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_8_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_8a_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_9_singlestep_unlit_hit", self.major_9)
        self.door_easter_start()
            

    def door_easter_start(self):
        print "door_easter_start"
        if (self.player.door_easter_running == 0):
            self.player.door_easter_ticks = self.player.door_easter_base_ticks
            self.player.door_easter_shots_needed = 3
            self.player.door_easter_score = 0
            self.player.door_easter_shots_revealed = 0
            self.set_shots()
            self.player.door_easter_running = 1
            self.machine.events.post("holiday_easter_music_start")
            self.ticks = self.player.door_easter_ticks 
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="door_easter_ticker", ms=delaytime, callback=self.ticker)

    def ticker(self):
        print "door_easter - 500ms tick"
        self.timeleft = int(self.player.door_easter_ticks/2)
        self.machine.events.post("door_easter_countdown", value=self.timeleft)
        self.player.door_easter_ticks -= 1;
        if self.player.door_easter_ticks <= 0:
            self.door_easter_stop()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="door_easter_ticker", ms=delaytime, callback=self.ticker)

    def door_easter_stop(self):
        if self.machine.game.player.door_easter_running == 1:
            self.machine.events.post('holiday_easter_music_stop')
            print "door_easter over"
            if self.player.door_easter_shots_revealed >= self.player.door_easter_shots_needed:
                self.machine.events.post('holiday_mode_stopped', state="complete")
                self.machine.game.player.door_easter_running = 2 #completed
            else:
                self.machine.events.post('holiday_mode_stopped', state="incomplete")
                self.machine.game.player.door_easter_running = 0 #ready to start again
            self.reset_shots()

    def set_shots(self):
        x = 0
        while x < 10:
            p = random.randint(0,9)
            if self.player.door_easter_shot_value[p] == 0:
                self.player.door_easter_shot_value[p] = self.player.door_easter_shot_pool[x]
                x += 1
        self.log.info('door_easter - shots - ' + str(self.player.door_easter_shot_value)) 
        for x in range(0, 10):
            self.machine.game.player.door_easter_shotlist[x]["state"] = "white_flash"
        self.set_shot_lights()


    def set_shot_lights(self):
        for x in range(0, 10):
            self.machine.light_controller.stop_script(key="holiday_easter_"+str(x))
        for x in range(0, 10):
            state = self.machine.game.player.door_easter_shotlist[x]["state"]
            led = self.machine.game.player.door_easter_shotlist[x]["led"]
            script_name = "sc_"+state
            self.log.info('door_easter - set shot lights - ' + str(x) + ' to ' + state)         
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            if state == "off":
                self.machine.light_controller.run_script(leds=led, script=scp, priority=45, tocks_per_sec=80, key="holiday_easter_"+str(x), repeat=0, blend=True)
            else:
                self.machine.light_controller.run_script(leds=led, script=scp, priority=45, tocks_per_sec=80, key="holiday_easter_"+str(x), blend=True)            

    def major_0(self, **kwargs):
        self.handle_shot(0)
    def major_1(self, **kwargs):
        self.handle_shot(1)
    def major_2(self, **kwargs):
        self.handle_shot(2)
    def major_3(self, **kwargs):
        self.handle_shot(3)
    def major_4(self, **kwargs):
        self.handle_shot(4)
    def major_5(self, **kwargs):
        self.handle_shot(5)
    def major_6(self, **kwargs):
        self.handle_shot(6)
    def major_7(self, **kwargs):
        self.handle_shot(7)
    def major_8(self, **kwargs):
        self.handle_shot(8)
    def major_9(self, **kwargs):
        self.handle_shot(9)
        

    def reveal_state(self, shot):
        val = self.player.door_easter_shot_value[shot]
        state = "off"
        if val == 1000000:
            state = "blue_flash"
        if val == 500000:
            state = "green_flash"
        if val == 250000:
            state = "yellow_flash"
        if val == 100000:
            state = "orange_flash"
        if val == 50000:
            state = "red_flash"
        self.machine.game.player.door_easter_shotlist[shot]["state"] = state
    

    def handle_shot(self, shot):
        if self.machine.game.player.door_easter_running == 1:
            self.log.info('door_easter - shot hit - ' + str(shot))         
            if self.machine.game.player.door_easter_shotlist[shot]["state"] == "white_flash":
                self.log.info('door_easter - reveal ')
                self.machine.events.post('easter_value_revealed')
                self.reveal_state(shot)
                self.player.door_easter_shots_revealed += 1
                if self.player.door_easter_shots_revealed == 3:
                    self.log.info('door_easter - 3 shots revealed')         
                    for x in range(0, 10):
                        state = self.machine.game.player.door_easter_shotlist[x]["state"]
                        if state == "white_flash":
                            self.machine.game.player.door_easter_shotlist[x]["state"] = "off"
                self.set_shot_lights()
            if self.machine.game.player.door_easter_shotlist[shot]["state"] != "off":
                self.log.info('door_easter - shot hit - ' + str(self.player.door_easter_shot_value[shot]))         
                self.machine.events.post('easter_value_collected')
                #score
                self.score = self.player.door_easter_shot_value[shot]
                self.score *= self.player.multiplier_shot_value_list[shot] # 1X, 2X or 3X 
                self.player.door_easter_score = self.score
                self.player.score += self.score
    
    def reset_shots(self):
        for x in range(0, 10):
            self.machine.game.player.door_easter_shotlist[x]["state"] = "off"
        self.set_shot_lights()


    def mode_stop(self, **kwargs):
        print 'Door_Easter mode_stop'
        self.door_easter_stop()
        self.reset_shots()

