from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Door_Christmas 
# Hinterlands Door Mode - "Naughty or Nice?" Multiball                                                                                                              Page 29
#
# Brief Description
# This multiball mode always has one shot lit for a few points and another 
# lit for a lot of points. When you make either, they both change to different shots.
#
# Scenario
# Santa's having a rather hard time figuring out who's been naughty or nice in 
# Halloween Town. You need to help him out!
#
# Details
# This is a 2-ball multiball which, unlike most multiballs in the game, 
# is not completed simply by starting it. During this multiball mode, two major shots, 
# selected at random, will be lit. One will be lit green for nice, the other red for 
# naughty. Shooting the green shot will award lots more points than shooting the red shot.
# Once you hit either of them though, BOTH will change to different major shots. 
# You must make three nice shots or three naughty shots to complete the mode, scoring 
# either a Nice Jackpot or a Naughty Jackpot. The interesting dichotomy of this mode is 
# that the Naughty Jackpot is actually worth more than the Nice Jackpot, but the
# naughty shots are worth significantly less than the nice shots. Once either jackpot 
# is awarded both the nice and naughty counters reset, meaning you need three of
# either again to score another jackpot. Scoring either jackpot also completes the mode.
#
# Scoring
# Nice Shots Base Value               1,000,000
# Nice Shots Increment                100,000
# Naughty Shots Base Value            200,000
# Naughty Shots Increment             20,000
# Nice Jackpot                        4,000,000
# Naughty Jackpot                     7,500,000
#
# Lighting
# Nice shots flash a green triangle while naughty shots flash a red triangle. 
# When either shot is ready for a jackpot it will also flash its circle.
#
# Difficulty Adjustments
# Very Easy        2 Shots for Jackpot
# Easy             2 Shots for Jackpot
# Normal           3 Shots for Jackpot
# Hard             3 Shots for Jackpot
# Very Hard        4 Shots for Jackpot

class Door_Christmas(Mode):

    def mode_init(self):
        print 'Door_Christmas Multiball mode_init'

    def mode_start(self, **kwargs):
        print 'Door_Christmas Multiball mode_start'
        self.delay = DelayManager()
        if self.player.door_christmas_started == 0:
            #once per game only
            self.player.door_christmas_started = 1
        self.player.door_christmas_running = 0
        self.nice_shot_score_base = 1000000
        self.nice_shot_score_inc = 100000
        self.nice_shot_score_jackpot = 4000000
        self.nice_shot_total = 0
        self.naughty_shot_score_base = 200000
        self.naughty_shot_score_inc = 2000
        self.naughty_shot_score_jackpot = 7500000
        self.naughty_shot_total = 0
        self.add_mode_event_handler('balldevice_trough_ball_enter', self.ball_drained)
        self.machine.game.player.door_christmas_shotlist = [
            {"led":"rgb_mayor_arrow", "state":"off"}
            ,{"led":"rgb_lorbit_arrow", "state":"off"}
            ,{"led":"rgb_lramp_arrow", "state":"off"}
            ,{"led":"rgb_leftloop_arrow", "state":"off"}
            ,{"led":"rgb_oogie_cw_arrow", "state":"off"}
            ,{"led":"rgb_oogie_ccw_arrow", "state":"off"}
            ,{"led":"rgb_grave_arrow", "state":"off"}
            ,{"led":"rgb_rramp_arrow", "state":"off"}
            ,{"led":"rgb_rorbit_arrow", "state":"off"}
            ,{"led":"rgb_soup_arrow", "state":"off"}
            ]
        self.add_mode_event_handler("major_0_singlestep_unlit_hit", self.major_0)
        self.add_mode_event_handler("major_1_singlestep_unlit_hit", self.major_1)
        self.add_mode_event_handler("major_2_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_2a_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_3_singlestep_unlit_hit", self.major_3)
        self.add_mode_event_handler("major_4_singlestep_unlit_hit", self.major_4)
        self.add_mode_event_handler("major_5_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_5a_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_6_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_6a_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_7_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_7a_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_8_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_8a_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_9_singlestep_unlit_hit", self.major_9)
        print "Start the Holiday Christmas Multiball mode"
        self.start_multiball()


    def start_multiball(self):
        if (self.player.door_christmas_running == 0):
            print "Started the Holiday Christmas Multiball mode"
            self.set_shots()
            self.machine.game.add_balls_in_play(1)
            self.machine.playfield.add_ball(balls=1, player_controlled=False)
            self.player.door_christmas_running = 1
            self.machine.events.post('holiday_christmas_music_start')
            self.machine.events.post('santa_now_who_could_that_be')
            self.machine.events.post('disable_combos')
            self.machine.events.post('add_a_ball_start')
            self.machine.events.post('enable_the_ball_save')            


    def set_shots(self):
        #pick 2 random shots set one to red, one to green
        for x in range(0, 10):
            self.machine.game.player.door_christmas_shotlist[x]["state"] = "off"
        nice = random.randint(0,9)
        naughty = random.randint(0,9)
        while (naughty == nice):
            naughty = random.randint(0,9)
        self.machine.game.player.door_christmas_shotlist[naughty]["state"] = "red_flash"
        self.machine.game.player.door_christmas_shotlist[nice]["state"] = "green_flash"
        self.set_shot_lights()


    def set_shot_lights(self):
        for x in range(0, 10):
            self.machine.light_controller.stop_script(key="holiday_christmas_"+str(x))
        for x in range(0, 10):
            state = self.machine.game.player.door_christmas_shotlist [x]["state"]
            led = self.machine.game.player.door_christmas_shotlist [x]["led"]
            print "Setting " + led + " to " + str(state)
            script_name = "sc_"+state
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=40, tocks_per_sec=80, key="holiday_christmas_"+str(x), repeat=True, blend=True)


    def major_0(self, **kwargs):
        self.handle_shot(0)
    def major_1(self, **kwargs):
        self.handle_shot(1)
    def major_2(self, **kwargs):
        self.handle_shot(2)
    def major_3(self, **kwargs):
        self.handle_shot(3)
    def major_4(self, **kwargs):
        self.handle_shot(4)
    def major_5(self, **kwargs):
        self.handle_shot(5)
    def major_6(self, **kwargs):
        self.handle_shot(6)
    def major_7(self, **kwargs):
        self.handle_shot(7)
    def major_8(self, **kwargs):
        self.handle_shot(8)
    def major_9(self, **kwargs):
        self.handle_shot(9)


    def handle_shot(self, shot):
        print "shot: " +str(shot)
        if self.machine.game.player.door_christmas_running == 1:
            if self.machine.game.player.door_christmas_shotlist[shot]["state"] == "red_flash":
                if self.naughty_shot_total < 2:
                    self.score = self.naughty_shot_score_base
                    self.naughty_shot_score_base += self.naughty_shot_score_inc
                    self.naughty_shot_total += 1
                    self.nice_shot_total = 0
                    self.machine.events.post('christmas_naughty_score_collected', value=self.score)
                    self.player["score"] += (self.score)
                else:
                    self.naughty_shot_score_base += self.naughty_shot_score_inc
                    self.score = self.naughty_shot_score_jackpot
                    self.naughty_shot_total = 0
                    self.nice_shot_total = 0
                    self.machine.events.post('christmas_naughty_jackpot_collected', value=self.score)
                    self.player["score"] += (self.score)
                self.set_shots()
            if self.machine.game.player.door_christmas_shotlist[shot]["state"] == "green_flash":
                if self.nice_shot_total < 2:
                    self.score = self.nice_shot_score_base
                    self.nice_shot_score_base += self.nice_shot_score_inc
                    self.nice_shot_total += 1
                    self.naughty_shot_total = 0
                    self.machine.events.post('christmas_nice_score_collected', value=self.score)
                    self.player["score"] += (self.score)
                else:
                    self.nice_shot_score_base += self.nice_shot_score_inc
                    self.score = self.nice_shot_score_jackpot
                    self.nice_shot_total = 0
                    self.naughty_shot_total = 0
                    self.machine.events.post('christmas_nice_jackpot_collected', value=self.score)
                    self.player["score"] += (self.score)
                self.set_shots()


    def mode_stop(self, **kwargs):
        print 'Holiday Christmas mode_stop'
        self.reset_shots()


    def reset_shots(self):
        for x in range(0, 10):
            self.machine.game.player.door_christmas_shotlist[x]["state"] = "off"
        self.set_shot_lights()


    def ball_drained(self, **kwargs):
        if self.machine.game.player.door_christmas_running == 1:
            print "Holiday Christmas multiball - ball drained"
            if self.machine.game.balls_in_play <= 2:
                if self.player.ball_save_active == 0:
                    #there is only 1 ball on playfield, end multiball
                    self.machine.game.player.door_christmas_running = 2
                    self.machine.events.post('holiday_christmas_music_stop')
                    self.reset_shots()
                    self.machine.events.post('holiday_mode_stopped', state="complete")
                    self.machine.events.post('enable_combos')
                    self.machine.events.post('add_a_ball_stop')
                else:
                    self.log.info( "LSB - MB - ball drained - but ball save is running" )
            else:
                self.log.info( "LSB - MB - ball drained - more than 2 BIP" )            
                                

