from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Character Mode - "Go Fetch!"                                                                                                                             Page 20
#
# Brief Description
# All major shots will blink.  Shoot one and it lights solid.  Repeat that shot for increasing jackpot
# Shoot a different shot and it resets.
# 
# Scenario
# Zero wants to play fetch, so Jack takes off one of his bones and tosses it out.
# 
# Details
# To complete this mode, all you have to do is make a major shot three times in a row. 
# Continue shooting same shot for more points.
# 
# Scoring
# 1st Major Shot                   500,000
# 2nd Major Shot                 1,000,000
# 3rd Major Shot                 2,000,000
# 4th Major Shot                 4,000,000
# 5th                            8,000,000
# 6th                           16,000,000
# 
# Lighting
# The major shots you need to make light the triangle yellow.
# 
# Difficulty Adjustments
# Very Easy         Make 2 Major Shots, 40 Second Time Limit
# Easy              Make 3 Major Shots, 40 Second Time Limit
# Normal            Make 3 Major Shots, 30 Second Time Limit
# Hard              Make 3 Major Shots, 25 Second Time Limit
# Very Hard         Make 4 Major Shots, 25 Second Time Limit

class Char_Zero(Mode):

# runs on MPF boot when the mode is read in and set up.
    def mode_init(self):
        print 'Char_zero mode_init'

    def mode_start(self, **kwargs):
        print 'Char_zero mode_start'
        self.delay = DelayManager()
        if self.player.Char_zero_started == 0:
            #once per game only
            self.player.Char_zero_started = 1
            self.player.Char_zero_running = 0
            self.player.Char_zero_base_ticks = 60 #30 seconds
            self.player.Char_zero_shots_needed = 3
            self.player.Char_zero_shot_index = -1
        self.player.Char_zero_shot_points = [100000,500000,1000000,2000000,4000000,8000000,16000000]            
        self.player.Char_zero_ticks = self.player.Char_zero_base_ticks
        self.player.Char_zero_shots_made = 0
        self.add_mode_event_handler('sw_zero', self.ball_at_zero)
        self.machine.game.player.Char_zero_shotlist = [
            {"led":"rgb_mayor_arrow", "state":"off"}
            ,{"led":"rgb_lorbit_arrow", "state":"off"}
            ,{"led":"rgb_lramp_arrow", "state":"off"}
            ,{"led":"rgb_leftloop_arrow", "state":"off"}
            ,{"led":"rgb_oogie_cw_arrow", "state":"off"}
            ,{"led":"rgb_oogie_ccw_arrow", "state":"off"}
            ,{"led":"rgb_grave_arrow", "state":"off"}
            ,{"led":"rgb_rramp_arrow", "state":"off"}
            ,{"led":"rgb_rorbit_arrow", "state":"off"}
            ,{"led":"rgb_soup_arrow", "state":"off"}
            ]
        self.add_mode_event_handler("major_0_singlestep_unlit_hit", self.major_0)
        self.add_mode_event_handler("major_1_singlestep_unlit_hit", self.major_1)
        self.add_mode_event_handler("major_2_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_2a_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_3_singlestep_unlit_hit", self.major_3)
        self.add_mode_event_handler("major_4_singlestep_unlit_hit", self.major_4)
        self.add_mode_event_handler("major_5_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_5a_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_6_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_6a_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_7_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_7a_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_8_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_8a_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_9_singlestep_unlit_hit", self.major_9)
        self.Char_zero_start()

    def Char_zero_start(self):
        print "Char_zero_start"
        if (self.player.Char_zero_running == 0):
            self.player.Char_zero_ticks = self.player.Char_zero_base_ticks
            self.player.Char_zero_shots_needed = 3
            self.player.Char_zero_score = 0
            self.player.Char_zero_shots_made = 0
            self.set_shots()
            self.player.Char_zero_running = 1
            self.player.Char_zero_shot_index = -1
            self.machine.events.post("Char_zero_music_start")
            self.ticks = self.player.Char_zero_ticks 
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="Char_zero_ticker", ms=delaytime, callback=self.ticker)

    def ticker(self):
        print "Char_zero - 500ms tick"
        self.player.Char_zero_timeleft = int(self.player.Char_zero_ticks/2)
        self.machine.events.post("Char_zero_countdown")
        self.player.Char_zero_ticks -= 1;
        if self.player.Char_zero_ticks <= 0:
            self.Char_zero_stop()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="Char_zero_ticker", ms=delaytime, callback=self.ticker)

    def Char_zero_stop(self):
        if self.machine.game.player.Char_zero_running == 1:
            self.machine.events.post('Char_zero_music_stop')
            print "Char_zero over"
            if self.player.Char_zero_shots_made >= self.player.Char_zero_shots_needed:
                self.machine.events.post('Char_mode_stopped', char_state="complete", char_mode="Zero")
                self.machine.game.player.Char_zero_running = 2 #completed
            else:
                self.machine.events.post('Char_mode_stopped', char_state="incomplete", char_mode="Zero")
                self.machine.game.player.Char_zero_running = 0 #ready to start again
            self.reset_shots()

    def set_shots(self):
        for x in range(0, 5):
            self.machine.game.player.Char_zero_shotlist[x]["state"] = "yellow_flash"
        self.set_shot_lights()

    def set_shot_lights(self):
        for x in range(0, 10):
            self.machine.light_controller.stop_script(key="Char_zero_"+str(x))
        for x in range(0, 10):
            state = self.machine.game.player.Char_zero_shotlist[x]["state"]
            led = self.machine.game.player.Char_zero_shotlist[x]["led"]
            script_name = "sc_"+state
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=80, key="Char_zero_"+str(x), blend=True)

    def set_zero_shot(self):
        for x in range(0, 10):
            self.machine.game.player.Char_zero_shotlist[x]["state"] = "off"
        self.machine.game.player.Char_zero_shotlist[self.player.Char_zero_shot_index]["state"] = "yellow_flash"             
        self.set_shot_lights()
        self.machine.events.post('say_here_you_go')
        
    def major_0(self, **kwargs):
        self.handle_shot(0)
    def major_1(self, **kwargs):
        self.handle_shot(1)
    def major_2(self, **kwargs):
        self.handle_shot(2)
    def major_3(self, **kwargs):
        self.handle_shot(3)
    def major_4(self, **kwargs):
        self.handle_shot(4)
    def major_5(self, **kwargs):
        self.handle_shot(5)
    def major_6(self, **kwargs):
        self.handle_shot(6)
    def major_7(self, **kwargs):
        self.handle_shot(7)
    def major_8(self, **kwargs):
        self.handle_shot(8)
    def major_9(self, **kwargs):
        self.handle_shot(9)


    def handle_shot(self, shot):
        if self.machine.game.player.Char_zero_running == 1:
            state = self.machine.game.player.Char_zero_shotlist[shot]["state"]
            if state == "yellow_flash":
                if self.player.Char_zero_shot_index != shot:
                    #first time for this shot
                    self.player.Char_zero_shot_index = shot
                    self.set_zero_shot()
                self.machine.events.post('zero_bark')
                if self.player.Char_zero_shots_made < 6:
                    score = self.player.Char_zero_shot_points[self.player.Char_zero_shots_made]
                else:
                    score = self.player.Char_zero_shot_points[6]
                score *= self.player.multiplier_shot_value_list[shot] # 1X, 2X or 3X
                self.player.Char_zero_score = score
                self.player.score += score
                self.player.Char_zero_shots_made  += 1
                self.log.info('Char_zero - score pts - ' + str(score))
            else:
                #this shot is unlit, reset the shot
                self.player.Char_zero_shot_index = shot
                self.set_zero_shot()
                self.player.Char_zero_shots_made = 0


    def ball_at_zero(self, **kwargs):
        #todo - more time with zero shot?
        print 'Char_zero - ball in zero again'
                

    def reset_shots(self):
        for x in range(0, 10):
            self.machine.game.player.Char_zero_shotlist[x]["state"] = "off"
        self.set_shot_lights()


    def mode_stop(self, **kwargs):
        print 'Char_zero mode_stop'
        self.Char_zero_stop()
        self.reset_shots()


