from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# disable mayor and zero diverters for this mode - ie always return Right Ramp to left flipper.

# Character Mode - "Where's Jack?" Multiball                                                                                                                           Page 15
# 
# Brief Description
# Simple 3-Ball multiball with a jackpot shot which needs to be relit once collected 
# and can be made super by completing other shots first.
# 
# Scenario
# Nobody in Halloween Town knows where Jack's gone off to, but then, 
# Jack's on his way back anyways so it's not a big deal.
# 
# Details
# Once started, the ball count is brought up to 3 and three of the major shots will light up, 
# one as a jackpot (always the right ramp), as well as two random shots as super qualifiers. 
# If you hit the two super qualifiers first, the jackpot shot will become a super jackpot, 
# but you must make it within 7 seconds or else it will time out, go back to a regular jackpot, 
# and two major shots will relight to qualify for a super. Once a jackpot or super jackpot is made, 
# the major shots will unlight and you must spell JACK to qualify another jackpot as well as the 
# super modifiers. The mode is completed simply by being started.
# 
# Scoring
# 1st Qualifying Shot                50,000
# 2nd Qualifying Shot                100,000
# 3rd Qualifying Shot                250,000
# Jackpot                            5,000,000
# Next Jackpot Increase              2,500,000
# Super Jackpot                      20,000,000
# Next Super Increase                10,000,000
# 
# Lighting
# The jackpot shot flashes yellow on the triangle only while the super qualifiers flash cyan 
# on their triangles. If you qualify a super, the jackpot will now flash white, both
# on the triangle and the circle. When the jackpot needs to be re-qualified, the JACK lights 
# will flash yellow and will go solid when one is hit. Once all are solid they will
# flash rapidly as the jackpot and super qualifier shots relight.
# 
# Difficulty Adjustments
# Very Easy    Only one shot to qualify super for 10 seconds, only need to hit one JACK standup to relight jackpots
# Easy         Two shots to qualify super for 10 seconds, only need to hit one JACK standup to relight jackpots
# Normal       Two shots to qualify super for 7 seconds, need to hit all four JACK standups to relight jackpots
# Hard         Three shots to qualify super for 7 seconds, need to hit all four JACK standups to relight jackpots
# Very Hard    Three shots to qualify super for 5 seconds, need to hit all four JACK standups to relight jackpots

class Char_Where(Mode):

    def mode_init(self):
        self.log.info('Char_where mode_init')

    def mode_start(self, **kwargs):
        self.log.info('Char_where mode_start')
        self.delay = DelayManager()
        if self.player.Char_where_started == 0:
            #once per game only
            self.player.Char_where_started = 1
            self.player.Char_where_running = 0
            self.player.Char_where_jackpots_made = 0
            self.player.Char_where_jackpots_base = 5000000
            self.player.Char_where_jackpots_inc = 2500000
            self.player.Char_where_super_jackpots_made = 0
            self.player.Char_where_super_jackpots_base = 20000000
            self.player.Char_where_super_jackpots_inc = 10000000
            self.player.Char_where_shot_index = [0,0,0]
            self.player.Char_where_shots_qualified_pts = [50000,100000,250000]            
            self.player.Char_where_shots_to_qualify = 2
            self.player.Char_where_shots_qualified = 0
            self.player.Char_where_shots_qualifier_timeout = "7s"
            self.player.Char_where_score = 0
            self.player.Char_where_jacks = 0
        self.machine.game.player.Char_where_shotlist = [
            {"led":"rgb_mayor_arrow", "state":"off"}
            ,{"led":"rgb_lorbit_arrow", "state":"off"}
            ,{"led":"rgb_lramp_arrow", "state":"off"}
            ,{"led":"rgb_leftloop_arrow", "state":"off"}
            ,{"led":"rgb_oogie_cw_arrow", "state":"off"}
            ,{"led":"rgb_oogie_ccw_arrow", "state":"off"}
            ,{"led":"rgb_grave_arrow", "state":"off"}
            ,{"led":"rgb_rramp_arrow", "state":"off"}
            ,{"led":"rgb_rorbit_arrow", "state":"off"}
            ,{"led":"rgb_soup_arrow", "state":"off"}
            ]
        self.add_mode_event_handler("major_0_singlestep_unlit_hit", self.major_0)
        self.add_mode_event_handler("major_1_singlestep_unlit_hit", self.major_1)
        self.add_mode_event_handler("major_2_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_2a_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_3_singlestep_unlit_hit", self.major_3)
        self.add_mode_event_handler("major_4_singlestep_unlit_hit", self.major_4)
        self.add_mode_event_handler("major_5_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_5a_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_6_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_6a_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_7_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_7a_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_8_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_8a_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_9_singlestep_unlit_hit", self.major_9)
        self.add_mode_event_handler('jack_standups_wheres_jack_lit_complete', self.handle_jack_complete)
        self.add_mode_event_handler('lrampstandup_left_wheres_jack_unlit_hit', self.handle_j_lit)
        self.add_mode_event_handler('lrampstandup_right_wheres_jack_unlit_hit', self.handle_a_lit)
        self.add_mode_event_handler('rrampstandup_left_wheres_jack_unlit_hit', self.handle_c_lit)
        self.add_mode_event_handler('rrampstandup_right_wheres_jack_unlit_hit', self.handle_k_lit)
        self.add_mode_event_handler('balldevice_trough_ball_enter', self.ball_drained)
        self.Char_where_start()


    def Char_where_start(self):
        self.log.info("Char_where_start")
        if (self.player.Char_where_running == 0):
            self.player.Char_where_ticks = self.player.Char_where_base_ticks
            self.player.Char_where_shot_made = 0
            self.set_shots()
            self.player.Char_where_running = 1
            self.player.Char_where_jacks = 0
            self.machine.events.post("Char_where_music_start")
            self.machine.events.post('disable_combos')
            bip = self.machine.game.balls_in_play 
            self.machine.game.add_balls_in_play(3-bip)
            self.machine.playfield.add_ball(balls=(3-bip), player_controlled=False)
            self.machine.events.post('add_a_ball_start')
            self.machine.events.post('enable_the_ball_save')


    def Char_where_stop(self):
        if self.machine.game.player.Char_where_running == 1:
            self.machine.events.post('Char_where_music_stop')
            self.log.info("Char_where over")
            if self.player.Char_where_shot_made > 0:
                self.machine.events.post('Char_mode_stopped', char_state="complete", char_mode="Where")
                self.machine.game.player.Char_where_running = 2 #completed
            else:
                self.machine.events.post('Char_mode_stopped', char_state="incomplete", char_mode="Where")
                self.machine.game.player.Char_where_running = 0 #ready to start again
            self.reset_shots()
            self.machine.events.post('enable_combos')
            self.machine.events.post('add_a_ball_stop')


    def ball_drained(self, **kwargs):
        if self.machine.game.player.Char_where_running == 1:
            self.log.info("Char_where - ball drained")
            self.log.info("Char_where - balls in play "+str(self.machine.game.balls_in_play))
            if self.machine.game.balls_in_play <= 2:
                if self.player.ball_save_active == 0:
                    #there is only 1 ball on playfield, end multiball
                    self.log.info("Char_where - Where's Jack MB over")
                    self.Char_where_stop()
                else:
                    self.log.info( "Char_where multiball - ball drained - but ball save is running" )
            else:
                self.log.info( "Char_where multiball - ball drained - more than 2 BIP" )            
                

    def set_shots(self):
        for x in range(0, 10):
            self.machine.game.player.Char_where_shotlist[x]["state"] = "off"
        shot_2 = random.randint(0,9)
        while (shot_2 == 7):
            shot_2 = random.randint(0,9)
        self.player.Char_where_shot_index[0] = shot_2  #qualifier 1
        shot_3 = random.randint(0,9)
        while (shot_3 == 7 or shot_3 == shot_2):
            shot_3 = random.randint(0,9)
        self.player.Char_where_shot_index[1] = shot_3  #qualifier 2
        shot_4 = random.randint(0,9)
        while (shot_4 == 7 or shot_4 == shot_3 or shot_4 == shot_2):
            shot_4 = random.randint(0,9)
        self.player.Char_where_shot_index[2] = shot_4  #qualifier 3
        for x in range(0, self.player.Char_where_shots_to_qualify):
            self.machine.game.player.Char_where_shotlist[self.player.Char_where_shot_index[x]]["state"] = "blue_flash"
        self.machine.game.player.Char_where_shotlist[7]["state"] = "yellow_flash"
        self.set_shot_lights()
        self.log.info('Char_where - shots - ' + str(self.machine.game.player.Char_where_shot_index)) 


    def timeout_qualifiers(self):
        self.log.info('Char_where - qualifiers timed out')
        for x in range(1, 10):
            self.machine.game.player.Char_where_shotlist[x]["state"] = "off"
        self.machine.game.player.Char_where_shots_qualified = 0
        self.set_shots()
        self.set_shot_lights()


    def set_shot_lights(self):
        for x in range(0, 10):
            self.machine.light_controller.stop_script(key="Char_where_"+str(x))
        for x in range(0, 10):
            state = self.machine.game.player.Char_where_shotlist[x]["state"]
            led = self.machine.game.player.Char_where_shotlist[x]["led"]
            script_name = "sc_"+state
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=120, key="Char_where_"+str(x), blend=True)

    def major_0(self, **kwargs):
        self.handle_shot(0)
    def major_1(self, **kwargs):
        self.handle_shot(1)
    def major_2(self, **kwargs):
        self.handle_shot(2)
    def major_3(self, **kwargs):
        self.handle_shot(3)
    def major_4(self, **kwargs):
        self.handle_shot(4)
    def major_5(self, **kwargs):
        self.handle_shot(5)
    def major_6(self, **kwargs):
        self.handle_shot(6)
    def major_7(self, **kwargs):
        self.handle_shot(7)
    def major_8(self, **kwargs):
        self.handle_shot(8)
    def major_9(self, **kwargs):
        self.handle_shot(9)

 
    def handle_j_lit(self, **kwargs):
        self.log.info('Char_where - handle_j_lit')
        self.machine.events.post('say_Oww')

    def handle_a_lit(self, **kwargs):
        self.log.info('Char_where - handle_a_lit')
        self.machine.events.post('say_Oww')

    def handle_c_lit(self, **kwargs):
        self.log.info('Char_where - handle_c_lit')
        self.machine.events.post('say_Oww')

    def handle_k_lit(self, **kwargs):
        self.log.info('Char_where - handle_k_lit')
        self.machine.events.post('say_Oww')
        
    def handle_jack_complete(self, **kwargs):
        if self.machine.game.player.Char_where_running == 1:  
            if self.machine.game.player.Char_where_shots_qualified == 0:
                # reset the shots/lights
                self.set_shots()

    def handle_shot(self, shot):
        self.log.info('Char_where - handle_shot')
        if self.machine.game.player.Char_where_running == 1:
            self.score = 0
            state = self.machine.game.player.Char_where_shotlist[shot]["state"]
            #not lit, skip it
            if state != "off":
                #qualifier or jackpot
                if state == "blue_flash":
                    self.machine.game.player.Char_where_shotlist[shot]["state"] = "off"
                    self.score = self.machine.game.player.Char_where_shots_qualified_pts[self.machine.game.player.Char_where_shots_qualified]
                    self.machine.game.player.Char_where_shots_qualified += 1
                    self.qualifier_hit(shot)
                else:
                    self.log.info('Char_where - ramp hit')
                    self.delay.remove('Char_where_qualifier_timeout')
                    if self.machine.game.player.Char_where_shots_qualified == self.machine.game.player.Char_where_shots_to_qualify:
                        #super jackpot
                        self.score = self.machine.game.player.Char_where_super_jackpots_base
                        self.score += self.machine.game.player.Char_where_super_jackpots_inc*self.machine.game.player.Char_where_super_jackpots_made
                        self.machine.game.player.Char_where_super_jackpots_made += 1
                        self.log.info('Char_where - super jackpot')
                        self.machine.events.post('char_where_sjackpot_hit')
                        self.machine.events.post('char_where_score_change')
                    else:
                        #regular jackpot                	  	
                        self.score = self.machine.game.player.Char_where_jackpots_base
                        self.score += self.machine.game.player.Char_where_jackpots_inc*self.machine.game.player.Char_where_jackpots_made
                        self.machine.game.player.Char_where_jackpots_made += 1
                        self.log.info('Char_where - jackpot')
                        self.machine.events.post('char_where_jackpot_hit')
                        self.machine.events.post('char_where_score_change')
                        for x in range(0, self.player.Char_where_shots_to_qualify):
                            self.machine.game.player.Char_where_shotlist[self.player.Char_where_shot_index[x]]["state"] = "off"
                    self.machine.game.player.Char_where_shotlist[7]["state"] = "off"
                    self.machine.game.player.Char_where_shots_qualified = 0
                    self.player.Char_where_shot_made += 1
                self.set_shot_lights()
                self.score *= self.player.multiplier_shot_value_list[shot] # 1X, 2X or 3X 
                self.player.score += self.score
                self.player.Char_where_score += self.score

    def qualifier_hit(self, x):
        self.log.info('Char_where - qualifier hit')
        self.delay.remove('Char_where_qualifier_timeout')
        delaytime = Timing.string_to_ms(self.machine.game.player.Char_where_shots_qualifier_timeout)
        self.delay.add(name="Char_where_qualifier_timeout", ms=delaytime, callback=self.timeout_qualifiers)
        if self.machine.game.player.Char_where_shots_qualified == self.machine.game.player.Char_where_shots_to_qualify:
            self.log.info('Char_where - make it a super jackpot!')
            self.machine.game.player.Char_where_shotlist[7]["state"] = "white_flash"
        self.set_shot_lights()
        if self.machine.game.player.Char_where_shots_qualified == 1:
            self.machine.events.post('char_where_qualifier_hit1')
        if self.machine.game.player.Char_where_shots_qualified == 2:
            self.machine.events.post('char_where_qualifier_hit2')
        if self.machine.game.player.Char_where_shots_qualified == 3:
            self.machine.events.post('char_where_qualifier_hit3')


    def jack_hit(self):
        if self.machine.game.player.Char_where_running == 1:   
            self.log.info('Char_where - jack completed')        	 	
            if self.machine.game.player.Char_where_shots_qualified == 0:
                self.machine.events.post("Char_where_value_increased")
                self.set_shots()
                self.set_shot_lights()


    def reset_shots(self):
        for x in range(0, 10):
            self.machine.game.player.Char_where_shotlist[x]["state"] = "off"
        self.set_shot_lights()


    def mode_stop(self, **kwargs):
        self.log.info('Char_where_mode_stop')
        self.Char_where_stop()
        self.reset_shots()

