from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random
     
# Character Mode - "What's This?" Frenzy                                                                                                                           Page 14
# 
# Brief Description
# 30 Second timed frenzy mode where almost all switches award points. Hitting any of the JACK targets increases the frenzy value. You must reach a target score to
# complete the frenzy and progress towards "Deliver the Presents".
# 
# Scenario
# Jack's fallen through the Christmas Town door in the Hinterlands and is wondering what everything is.
# 
# Details
# To help Jack discover the magic of Christmas Town you must shoot everything! The base value for every switch starts at 40,000, but hitting any of the JACK
# standups increases this value by 5,000. The mode only lasts 30 seconds and you must score at least 2,000,000 to complete and end the mode.
# 
# Scoring
# Frenzy Base Value                 40,000
# Increments to Base Value          5,000 / each
# 
# Lighting
# The lighting in this mode is mostly just festive and fun and meant to distract the player. The JACK targets will be flashing yellow and will ALL flash green briefly when
# one is hit to indicate the increase in the frenzy value.
# 
# Difficulty Adjustments
# Very Easy         40 Seconds - Goal of 1,000,000 Points
# Easy              35 Seconds - Goal of 1,500,000 Points
# Normal            30 Seconds - Goal of 2,000,000 Points
# Hard              30 Seconds - Goal of 2,500,000 Points
# Very Hard         25 Seconds - Goal of 3,000,000 Points

class Char_What(Mode):

    def mode_init(self):
        print 'Char_what mode_init'

    def mode_start(self, **kwargs):
        print 'Char_what mode_start'
        self.delay = DelayManager()
        if self.player.Char_what_started == 0:
            #once per game only
            self.player.Char_what_started = 1
            self.player.Char_what_running = 0
            self.player.Char_what_base_ticks = 60 #30 seconds
        self.player.Char_what_ticks = self.player.Char_what_base_ticks
        self.player.Char_what_Jacks = 0
        self.player.Char_what_score = 0
        self.player.Char_what_value = 0        
        self.machine.game.player.Char_what_shotlist = [
            {"led":"rgb_mayor_arrow", "state":"off"}
            ,{"led":"rgb_lorbit_arrow", "state":"off"}
            ,{"led":"rgb_lramp_arrow", "state":"off"}
            ,{"led":"rgb_leftloop_arrow", "state":"off"}
            ,{"led":"rgb_oogie_cw_arrow", "state":"off"}
            ,{"led":"rgb_oogie_ccw_arrow", "state":"off"}
            ,{"led":"rgb_grave_arrow", "state":"off"}
            ,{"led":"rgb_rramp_arrow", "state":"off"}
            ,{"led":"rgb_rorbit_arrow", "state":"off"}
            ,{"led":"rgb_soup_arrow", "state":"off"}
            ,{"led":"rgb_lramp_ldiamond", "state":"off"}
            ,{"led":"rgb_lramp_rdiamond", "state":"off"}
            ,{"led":"rgb_lock_rect", "state":"off"}
            ,{"led":"rgb_shock_rect", "state":"off"}
            ,{"led":"rgb_barrel_rect", "state":"off"}
            ,{"led":"rgb_bug_1", "state":"off"}
            ,{"led":"rgb_bug_2", "state":"off"}
            ,{"led":"rgb_bug_3", "state":"off"}
            ,{"led":"rgb_mystery_rect", "state":"off"}
            ,{"led":"rgb_rramp_ldiamond", "state":"off"}
            ,{"led":"rgb_rramp_rdiamond", "state":"off"}
            ,{"led":"rgb_doctor_rect", "state":"off"}
            ]
        self.add_mode_event_handler("major_0_singlestep_unlit_hit", self.major_0)
        self.add_mode_event_handler("major_1_singlestep_unlit_hit", self.major_1)
        self.add_mode_event_handler("major_2_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_2a_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_3_singlestep_unlit_hit", self.major_3)
        self.add_mode_event_handler("major_4_singlestep_unlit_hit", self.major_4)
        self.add_mode_event_handler("major_5_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_5a_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_6_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_6a_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_7_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_7a_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_8_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_8a_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_9_singlestep_unlit_hit", self.major_9)
        self.add_mode_event_handler('sw_bugbashtarget1', self.bug_hit1)
        self.add_mode_event_handler('sw_bugbashtarget2', self.bug_hit2)
        self.add_mode_event_handler('sw_bugbashtarget3', self.bug_hit3)
        self.add_mode_event_handler('sw_bugbashtarget4', self.bug_hit4)
        self.add_mode_event_handler('sw_bugbashtarget5', self.bug_hit5)
        self.add_mode_event_handler('sw_bugbashtarget6', self.bug_hit6)
        self.add_mode_event_handler('sw_bugbashtarget7', self.bug_hit7)
        self.add_mode_event_handler('sw_bugbashtarget8', self.bug_hit8)
        self.add_mode_event_handler('sw_bugbashtarget9', self.bug_hit9)
        self.add_mode_event_handler('sw_bugbashtarget10', self.bug_hit10)
        self.add_mode_event_handler('sw_bugbashtarget11', self.bug_hit11)
        self.add_mode_event_handler('sw_bugbashtarget12', self.bug_hit12)
        self.Char_what_start()


    def Char_what_start(self):
        print "Char_what_start"
        if (self.player.Char_what_running == 0):
            self.player.Char_what_ticks = self.player.Char_what_base_ticks
            self.player.Char_what_needed = 1000000
            self.player.Char_what_value = 40000
            self.player.Char_what_score = 0
            self.player.Char_what_Jacks = 0
            self.set_shots()
            self.player.Char_what_running = 1
            self.machine.events.post("Char_what_music_start")
            self.ticks = self.player.Char_what_ticks 
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="Char_what_ticker", ms=delaytime, callback=self.ticker)

    def ticker(self):
        print "Char_what - 500ms tick"
        self.timeleft = int(self.player.Char_what_ticks/2)
        self.machine.events.post("Char_what_countdown", value=self.timeleft)
        self.player.Char_what_ticks -= 1;
        if self.player.Char_what_ticks <= 0:
            self.Char_what_stop()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="Char_what_ticker", ms=delaytime, callback=self.ticker)

    def Char_what_stop(self):
        if self.machine.game.player.Char_what_running == 1:
            self.machine.events.post('Char_what_music_stop')
            print "Char_what over"
            if self.player.Char_what_score >= self.player.Char_what_needed:
                self.machine.events.post('Char_mode_stopped', char_state="complete", char_mode="What")
                self.machine.game.player.Char_what_running = 2 #completed
            else:
                self.machine.events.post('Char_mode_stopped', char_state="incomplete", char_mode="What")
                self.machine.game.player.Char_what_running = 0 #ready to start again
            self.reset_shots()


    def set_shots(self):
        for x in range(0, 22):
            self.machine.game.player.Char_what_shotlist[x]["state"] = "rainbow"
        self.set_shot_lights()


    def set_shot_lights(self):
        for x in range(0, 22):
            self.machine.light_controller.stop_script(key="Char_what_"+str(x))
        for x in range(0, 22):
            state = self.machine.game.player.Char_what_shotlist[x]["state"]
            led = self.machine.game.player.Char_what_shotlist[x]["led"]
            script_name = "sc_"+state
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=80, key="Char_what_"+str(x), blend=True)


    def major_0(self, **kwargs):
        self.handle_shot(0)
    def major_1(self, **kwargs):
        self.handle_shot(1)
    def major_2(self, **kwargs):
        self.handle_shot(2)
    def major_3(self, **kwargs):
        self.handle_shot(3)
    def major_4(self, **kwargs):
        self.handle_shot(4)
    def major_5(self, **kwargs):
        self.handle_shot(5)
    def major_6(self, **kwargs):
        self.handle_shot(6)
    def major_7(self, **kwargs):
        self.handle_shot(7)
    def major_8(self, **kwargs):
        self.handle_shot(8)
    def major_9(self, **kwargs):
        self.handle_shot(9)
    def bug_hit1(self, **kwargs):
        self.handle_shot(10)
        self.jack_hit()
    def bug_hit2(self, **kwargs):
        self.handle_shot(11)
        self.jack_hit()        
    def bug_hit3(self, **kwargs):
        self.handle_shot(12)
    def bug_hit4(self, **kwargs):
        self.handle_shot(13)
    def bug_hit5(self, **kwargs):
        self.handle_shot(14)
    def bug_hit6(self, **kwargs):
        self.handle_shot(15)
    def bug_hit7(self, **kwargs):
        self.handle_shot(16)
    def bug_hit8(self, **kwargs):
        self.handle_shot(17)
    def bug_hit9(self, **kwargs):
        self.handle_shot(18)
    def bug_hit10(self, **kwargs):
        self.handle_shot(19)
        self.jack_hit()        
    def bug_hit11(self, **kwargs):
        self.handle_shot(20)
        self.jack_hit()        
    def bug_hit12(self, **kwargs):
        self.handle_shot(21)


    def handle_shot(self, shot):
        if self.machine.game.player.Char_what_running == 1:
            self.score = self.player.Char_what_value
            if shot < 10:
                self.score *= self.player.multiplier_shot_value_list[shot] # 1X, 2X or 3X 
            self.player.Char_what_score += self.score
            self.player.score += self.score
            self.log.info('Char_what - score - ' + str(self.score)) 
            nb = random.randint(1,3)
            self.machine.events.post('say_whats_this_'+str(nb))                       


    def jack_hit(self, **kwargs):
        if self.machine.game.player.Char_what_running == 1:    	
            self.player.Char_what_Jacks += 1
            self.player.Char_what_value = 40000+self.player.Char_what_Jacks*5000            
            self.log.info('Char_what - JACK letter hit - value at - ' + str(self.player.Char_what_value))
            self.machine.events.post("Char_what_value_increased")


    def reset_shots(self, **kwargs):
        for x in range(0, 22):
            self.machine.game.player.Char_what_shotlist[x]["state"] = "off"
        self.set_shot_lights()


    def mode_stop(self, **kwargs):
        print 'Char_what mode_stop'
        self.Char_what_stop()
        self.reset_shots()


