from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Character Mode - "The Scientific Method" Multiball                                                                                                                    Page 16
# 
# Brief Description
# Special multiball played instead of "WHere's Jack?" 
# if all other character modes are completed before trying to start "Science's Jack?" for your first time. 
# The goal is to make randomly selected major shots, then get the ball into the graveyard for a jackpot.
#
# Scenario
# Jack is up in his tower trying to figure out what makes Christmas so special. 
# He needs to experiment with various things to discover the answers he seeks.
# 
# Details
# When this mode begins, the ball count is brought up to 2, the gravestone is reset, 
# and two major shots (excluding the graveyard) will be selected at random. 
# Add-a-Ball is disabled for this multiball. When you shoot a lit major shot, 
# it will be cleared. Once all major shots are cleared, the gravestone can be knocked down 
# and entering the Graveyard will award a jackpot. Attempting to shoot the graveyard without 
# a jackpot lit will reset the gravestone immediately. You can upgrade the
# jackpot into a super jackpot by spelling JACK entirely after the jackpot is lit 
# but before collecting it. Once a jackpot is collected, the ball count will increase by 1, 
# a 10 second ball saver will be activated, and the number of major shots you need to clear 
# for the next jackpot to light will also be one higher. You can get the ball count all
# the way up to 5, though the number of major shots to clear can go as high as 7. 
# Once no more balls are added no more ball saver time will be awarded. The mode is
# completed simply by being started.
# 
# Scoring
# Lit Major Shot                       200,000
# Jackpot                              10,000,000
# Next Jackpot Increase                1,000,000
# Super Jackpot                        25,000,000
# Next Super Increase                  5,000,000
# 
# Lighting
# The major shots flash yellow triangles. 
# When the jackpot is ready the graveyard shot will flash a yellow triangle and the 
# JACK lights will flash cyan. When you hit a JACK standup the light will go solid. 
# If all JACK lights are completed they will rapidly flash white for a moment and the 
# graveyard shot will flash white on both the triangle and circle.
# 
# Difficulty Adjustments
# Very Easy         1 Major Shot Initially to Light Jackpot, Maximum Ball Count of 5, Ball Saver 30 sec Initial, 15 sec Additional
# Easy              2 Major Shots Initially to Light Jackpot, Maximum Ball Count of 5, Ball Saver 30 sec Initial, 15 sec Additional
# Normal            2 Major Shots Initially to Light Jackpot, Maximum Ball Count of 5, Ball Saver 20 sec Initial, 10 sec Additional
# Hard              2 Major Shots Initially to Light Jackpot, Maximum Ball Count of 4, Ball Saver 15 sec Initial, 7 sec Additional
# Very Hard         3 Major Shots Initially to Light Jackpot, Maximum Ball Count of 4, Ball Saver 15 sec Initial, 7 sec Additional

class Char_Science(Mode):

    def mode_init(self):
        self.log.info('Char_science mode_init')

    def mode_start(self, **kwargs):
        self.log.info('Char_science mode_start')
        self.delay = DelayManager()
        if self.player.Char_science_started == 0:
            #once per game only
            self.player.Char_science_started = 1
            self.player.Char_science_running = 0
            self.player.Char_science_jackpots_made = 0
            self.player.Char_science_jackpots_base = 5000000
            self.player.Char_science_jackpots_inc = 2500000
            self.player.Char_science_super_jackpots_made = 0
            self.player.Char_science_super_jackpots_base = 20000000
            self.player.Char_science_super_jackpots_inc = 10000000
            self.player.Char_science_shot_index = [0,0,0]
            self.player.Char_science_shots_qualified_pts = [50000,100000,250000]            
            self.player.Char_science_shots_to_qualify = 2
            self.player.Char_science_shots_qualified = 0
            self.player.Char_science_shots_qualifier_timeout = "7s"
            self.player.Char_science_score = 0
            self.player.Char_science_jacks = 0
        self.machine.game.player.Char_science_shotlist = [
            {"led":"rgb_mayor_arrow", "state":"off"}
            ,{"led":"rgb_lorbit_arrow", "state":"off"}
            ,{"led":"rgb_lramp_arrow", "state":"off"}
            ,{"led":"rgb_leftloop_arrow", "state":"off"}
            ,{"led":"rgb_oogie_cw_arrow", "state":"off"}
            ,{"led":"rgb_oogie_ccw_arrow", "state":"off"}
            ,{"led":"rgb_grave_arrow", "state":"off"}
            ,{"led":"rgb_rramp_arrow", "state":"off"}
            ,{"led":"rgb_rorbit_arrow", "state":"off"}
            ,{"led":"rgb_soup_arrow", "state":"off"}
            ]
        self.add_mode_event_handler("major_0_singlestep_unlit_hit", self.major_0)
        self.add_mode_event_handler("major_1_singlestep_unlit_hit", self.major_1)
        self.add_mode_event_handler("major_2_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_2a_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_3_singlestep_unlit_hit", self.major_3)
        self.add_mode_event_handler("major_4_singlestep_unlit_hit", self.major_4)
        self.add_mode_event_handler("major_5_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_5a_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_6_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_6a_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_7_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_7a_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_8_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_8a_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_9_singlestep_unlit_hit", self.major_9)
        self.add_mode_event_handler('jack_standups_science_jack_lit_complete', self.handle_jack_complete)
        self.add_mode_event_handler('lrampstandup_left_science_jack_unlit_hit', self.handle_j_lit)
        self.add_mode_event_handler('lrampstandup_right_science_jack_unlit_hit', self.handle_a_lit)
        self.add_mode_event_handler('rrampstandup_left_science_jack_unlit_hit', self.handle_c_lit)
        self.add_mode_event_handler('rrampstandup_right_science_jack_unlit_hit', self.handle_k_lit)
        self.add_mode_event_handler('balldevice_trough_ball_enter', self.ball_drained)
        self.Char_science_start()


    def Char_science_start(self):
        self.log.info("Char_science_start")
        if (self.player.Char_science_running == 0):
            self.player.Char_science_ticks = self.player.Char_science_base_ticks
            self.player.Char_science_shot_made = 0
            self.set_shots()
            self.player.Char_science_running = 1
            self.player.Char_science_jacks = 0
            self.machine.events.post("Char_science_music_start")
            self.machine.events.post('disable_combos')
            bip = self.machine.game.balls_in_play 
            self.machine.game.add_balls_in_play(3-bip)
            self.machine.playfield.add_ball(3-bip)
            self.machine.events.post('add_a_ball_start')


    def Char_science_stop(self):
        if self.machine.game.player.Char_science_running == 1:
            self.machine.events.post('Char_science_music_stop')
            self.log.info("Char_science over")
            if self.player.Char_science_shot_made > 0:
                self.machine.events.post('Char_mode_stopped', char_state="complete", char_mode="Science")
                self.machine.game.player.Char_science_running = 2 #completed
            else:
                self.machine.events.post('Char_mode_stopped', char_state="incomplete", char_mode="Science")
                self.machine.game.player.Char_science_running = 0 #ready to start again
            self.reset_shots()
            self.machine.events.post('enable_combos')
            self.machine.events.post('add_a_ball_stop')


    def ball_drained(self, **kwargs):
        if self.machine.game.player.Char_science_running == 1:
            self.log.info("Char_science - ball drained")
            self.log.info("Char_science - balls in play "+str(self.machine.game.balls_in_play))
            if self.machine.game.balls_in_play <= 2:
                if self.player.ball_save_active == 0:
                    #there is only 1 ball on playfield, end multiball
                    self.log.info("Char_science - Science's Jack MB over")
                    self.Char_science_stop()
                else:
                    self.log.info( "Char_science multiball - ball drained - but ball save is running" )
            else:
                self.log.info( "Char_science multiball - ball drained - more than 2 BIP" )            
                

    def set_shots(self):
        for x in range(0, 10):
            self.machine.game.player.Char_science_shotlist[x]["state"] = "off"
        shot_2 = random.randint(0,9)
        while (shot_2 == 7):
            shot_2 = random.randint(0,9)
        self.player.Char_science_shot_index[0] = shot_2  #qualifier 1
        shot_3 = random.randint(0,9)
        while (shot_3 == 7 or shot_3 == shot_2):
            shot_3 = random.randint(0,9)
        self.player.Char_science_shot_index[1] = shot_3  #qualifier 2
        shot_4 = random.randint(0,9)
        while (shot_4 == 7 or shot_4 == shot_3 or shot_4 == shot_2):
            shot_4 = random.randint(0,9)
        self.player.Char_science_shot_index[2] = shot_4  #qualifier 3
        for x in range(0, self.player.Char_science_shots_to_qualify):
            self.machine.game.player.Char_science_shotlist[self.player.Char_science_shot_index[x]]["state"] = "blue_flash"
        self.machine.game.player.Char_science_shotlist[7]["state"] = "yellow_flash"
        self.set_shot_lights()
        self.log.info('Char_science - shots - ' + str(self.machine.game.player.Char_science_shot_index)) 


    def timeout_qualifiers(self):
        self.log.info('Char_science - qualifiers timed out')
        for x in range(1, 10):
            self.machine.game.player.Char_science_shotlist[x]["state"] = "off"
        self.machine.game.player.Char_science_shots_qualified = 0
        self.set_shots()
        self.set_shot_lights()


    def set_shot_lights(self):
        for x in range(0, 10):
            self.machine.light_controller.stop_script(key="Char_science_"+str(x))
        for x in range(0, 10):
            state = self.machine.game.player.Char_science_shotlist[x]["state"]
            led = self.machine.game.player.Char_science_shotlist[x]["led"]
            script_name = "sc_"+state
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=120, key="Char_science_"+str(x), blend=True)

    def major_0(self, **kwargs):
        self.handle_shot(0)
    def major_1(self, **kwargs):
        self.handle_shot(1)
    def major_2(self, **kwargs):
        self.handle_shot(2)
    def major_3(self, **kwargs):
        self.handle_shot(3)
    def major_4(self, **kwargs):
        self.handle_shot(4)
    def major_5(self, **kwargs):
        self.handle_shot(5)
    def major_6(self, **kwargs):
        self.handle_shot(6)
    def major_7(self, **kwargs):
        self.handle_shot(7)
    def major_8(self, **kwargs):
        self.handle_shot(8)
    def major_9(self, **kwargs):
        self.handle_shot(9)

 
    def handle_j_lit(self, **kwargs):
        self.log.info('Char_science - handle_j_lit')
        self.machine.events.post('say_Oww')

    def handle_a_lit(self, **kwargs):
        self.log.info('Char_science - handle_a_lit')
        self.machine.events.post('say_Oww')

    def handle_c_lit(self, **kwargs):
        self.log.info('Char_science - handle_c_lit')
        self.machine.events.post('say_Oww')

    def handle_k_lit(self, **kwargs):
        self.log.info('Char_science - handle_k_lit')
        self.machine.events.post('say_Oww')
        
    def handle_jack_complete(self):
        if self.machine.game.player.Char_science_running == 1:  
            if self.machine.game.player.Char_science_shots_qualified == 0:
                # reset the shots/lights
                self.set_shots()

    def handle_shot(self, shot):
        self.log.info('Char_science - handle_shot')
        if self.machine.game.player.Char_science_running == 1:
            self.score = 0
            state = self.machine.game.player.Char_science_shotlist[shot]["state"]
            #not lit, skip it
            if state != "off":
                #qualifier or jackpot
                if state == "blue_flash":
                    self.machine.game.player.Char_science_shotlist[shot]["state"] = "off"
                    self.score = self.machine.game.player.Char_science_shots_qualified_pts[self.machine.game.player.Char_science_shots_qualified]
                    self.machine.game.player.Char_science_shots_qualified += 1
                    self.qualifier_hit(shot)
                else:
                    self.log.info('Char_science - ramp hit')
                    self.delay.remove('Char_science_qualifier_timeout')
                    if self.machine.game.player.Char_science_shots_qualified == self.machine.game.player.Char_science_shots_to_qualify:
                        #super jackpot
                        self.score = self.machine.game.player.Char_science_super_jackpots_base
                        self.score += self.machine.game.player.Char_science_super_jackpots_inc*self.machine.game.player.Char_science_super_jackpots_made
                        self.machine.game.player.Char_science_super_jackpots_made += 1
                        self.log.info('Char_science - super jackpot')
                        self.machine.events.post('char_science_sjackpot_hit')
                        self.machine.events.post('char_science_score_change')
                    else:
                        #regular jackpot                	  	
                        self.score = self.machine.game.player.Char_science_jackpots_base
                        self.score += self.machine.game.player.Char_science_jackpots_inc*self.machine.game.player.Char_science_jackpots_made
                        self.machine.game.player.Char_science_jackpots_made += 1
                        self.log.info('Char_science - jackpot')
                        self.machine.events.post('char_science_jackpot_hit')
                        self.machine.events.post('char_science_score_change')
                        for x in range(0, self.player.Char_science_shots_to_qualify):
                            self.machine.game.player.Char_science_shotlist[self.player.Char_science_shot_index[x]]["state"] = "off"
                    self.machine.game.player.Char_science_shotlist[7]["state"] = "off"
                    self.machine.game.player.Char_science_shots_qualified = 0
                    self.player.Char_science_shot_made += 1
                self.set_shot_lights()
                self.score *= self.player.multiplier_shot_value_list[shot] # 1X, 2X or 3X 
                self.player.score += self.score
                self.player.Char_science_score += self.score

    def qualifier_hit(self, x):
        self.log.info('Char_science - qualifier hit')
        self.delay.remove('Char_science_qualifier_timeout')
        delaytime = Timing.string_to_ms(self.machine.game.player.Char_science_shots_qualifier_timeout)
        self.delay.add(name="Char_science_qualifier_timeout", ms=delaytime, callback=self.timeout_qualifiers)
        if self.machine.game.player.Char_science_shots_qualified == self.machine.game.player.Char_science_shots_to_qualify:
            self.log.info('Char_science - make it a super jackpot!')
            self.machine.game.player.Char_science_shotlist[7]["state"] = "white_flash"
        self.set_shot_lights()
        if self.machine.game.player.Char_science_shots_qualified == 1:
            self.machine.events.post('char_science_qualifier_hit1')
        if self.machine.game.player.Char_science_shots_qualified == 2:
            self.machine.events.post('char_science_qualifier_hit2')
        if self.machine.game.player.Char_science_shots_qualified == 3:
            self.machine.events.post('char_science_qualifier_hit3')


    def jack_hit(self):
        if self.machine.game.player.Char_science_running == 1:   
            self.log.info('Char_science - jack completed')        	 	
            if self.machine.game.player.Char_science_shots_qualified == 0:
                self.machine.events.post("Char_science_value_increased")
                self.set_shots()
                self.set_shot_lights()


    def reset_shots(self):
        for x in range(0, 10):
            self.machine.game.player.Char_science_shotlist[x]["state"] = "off"
        self.set_shot_lights()


    def mode_stop(self, **kwargs):
        self.log.info('Char_science_mode_stop')
        self.Char_science_stop()
        self.reset_shots()

        
