from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Character Mode - "Sally's Stitches"                                                                                                                                   Page 17
# 
# Brief Description
# Shoot the spinner to get lots of points and to complete the mode before time runs out. 
# Upper right flipper is disabled for the duration.
# 
# Scenario
# Sally's arm has come off! She must stitch it back on before anyone comes looking for her.
# 
# Details
# When the mode begins and for the duration of the mode, the upper right flipper is completely 
# disabled and the popup post will be on standby to raise when the ball
# enters the loops. You must get 100 spinner spins to complete the mode and have 30 seconds to 
# do so within, which seems very tricky, but you can upgrade the
# spinner during this mode by getting the ball into the pop bumpers. 10 pop hits will give one 
# spinner upgrade so that each spin is now worth double. 20 more pop hits
# afterwards will triple the spinner. The shot multiplier will also factor in, thus a tripler 
# on the spinner shot combined with a triple upgrade will award 9 spins at a time!
# 
# Scoring
# Spinner Spin               25,000 (multiplied by upgrades)
# 
# Lighting
# The pops will all flash orange to indicate that hitting them can get you an upgrade. 
# Once both upgrades are acquired, the pop bumpers stop flashing. The spinner
# shot will have a flashing yellow triangle.
# 
# Difficulty Adjustments
# Very Easy         40 Seconds, 60 Spins Needed, 6 + 12 Pops for Upgrades
# Easy              30 Seconds, 80 Spins Needed, 8 + 16 Pops for Upgrades
# Normal            30 Seconds, 100 Spins Needed, 10 + 20 Pops for Upgrades
# Hard              30 Seconds, 120 Spins Needed, 12 + 24 Pops for Upgrades
# Very Hard         25 Seconds, 150 Spins Needed, 15 + 30 Pops for Upgrades

# orbits will pop up the post until all pops are at max
class Char_Sally(Mode):

    def mode_init(self):
        self.log.info('Char_Sally mode_init')

    def mode_start(self, **kwargs):
        self.log.info( 'Char_Sally mode_start' )
        self.delay = DelayManager()
        if self.machine.game.player.Char_sally_started == 0:
            #once per game only
            self.machine.game.player.Char_sally_started = 1 
            self.player.Char_sally_running = 0
            #these should come from settings
            self.player.Char_sally_base_ticks = 60 #30 seconds
            self.player.Char_sally_pop_upgrade_1 = 10
            self.player.Char_sally_pop_upgrade_2 = 10+10
            self.player.Char_sally_pop_upgrade_3 = 10+10+10
            self.player.Char_sally_pop_upgrade_4 = 10+10+10+10                        
            self.player.Char_sally_pops = 0
            self.player.Char_sally_spins_needed = 100
            self.player.Char_sally_spin_value = 1
        self.player.Char_sally_ticks = self.player.Char_sally_base_ticks
        self.add_mode_event_handler('sw_sally', self.spin)
        self.machine.game.player.Char_sally_shotlist = [
            {"led":"rgb_rorbit_arrow", "state":"off"}
            ,{"led":"rgb_lorbit_arrow", "state":"off"}
            ]
        self.add_mode_event_handler('Char_Sally_start', self.Char_sally_start)
        self.add_mode_event_handler('sw_bumpertop', self.pophit)
        self.add_mode_event_handler('sw_bumperleft', self.pophit)
        self.add_mode_event_handler('sw_bumperright', self.pophit)
        self.Char_sally_start()      


    def Char_sally_start(self):
        self.log.info( "Char_sally start")
        if (self.player.Char_sally_running == 0):
            self.player.Char_sally_running = 1
            self.player.Char_sally_ticks = self.player.Char_sally_base_ticks
            self.player.Char_sally_spins_needed = 100
            self.player.Char_sally_pops = 0
            self.machine.events.post("Char_sally_music_start")
            self.ticks = self.player.Char_sally_ticks 
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="Char_sally_ticker", ms=delaytime, callback=self.ticker)
            self.set_lights()
            self.disable_flipper()
            self.machine.events.post('popuppost_enable_up')

    def ticker(self):
        self.log.info( "Char_Sally - 500ms tick")
        self.timeleft = int(self.player.Char_sally_ticks/2)
        self.machine.events.post("Char_sally_countdown", value=self.timeleft)
        self.player.Char_sally_ticks -= 1;
        if self.player.Char_sally_ticks > 30:
            self.machine.events.post("set_gi_col", red=150, green=40, blue=40)
        else:
            if self.player.Char_sally_ticks%2 == 0:        
                self.machine.events.post("set_gi_col", red=self.player.Char_sally_ticks*5, green=40, blue=40)         
            else:
                self.machine.events.post("set_gi_col", red=150, green=40, blue=40)                     
        if self.player.Char_sally_ticks <= 0:
            self.Char_sally_stop()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="Char_sally_ticker", ms=delaytime, callback=self.ticker)

    def Char_sally_stop(self):
        if self.machine.game.player.Char_sally_running == 1:
            self.machine.events.post('Char_sally_music_stop')
            self.log.info( "Char_sally over")
            if self.player.Char_Sally_score >= self.player.Char_sally_needed:
                self.machine.events.post('Char_mode_stopped', char_state="complete", char_mode="Sally")
                self.machine.game.player.Char_sally_running = 2 #completed
            else:
                self.machine.events.post('Char_mode_stopped', char_state="incomplete", char_mode="Sally")
                self.machine.game.player.Char_sally_running = 0 #ready to start again
            self.reset_lights()
            self.enable_flipper()
            self.machine.events.post('popuppost_disable_up')


    def set_lights(self):
        for x in range(0, 2):
            self.machine.game.player.Char_sally_shotlist[x]["state"] = "pink_flash"
            state = self.machine.game.player.Char_sally_shotlist[x]["state"]
            led = self.machine.game.player.Char_sally_shotlist[x]["led"]
            script_name = "sc_"+state
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=80, key="Char_sally_"+str(x), blend=True)


    def reset_lights(self):
        for x in range(0, 2):
            self.machine.light_controller.stop_script(key="Char_sally_"+str(x))
            self.machine.game.player.Char_sally_shotlist[x]["state"] = "off"
            state = self.machine.game.player.Char_sally_shotlist[x]["state"]
            led = self.machine.game.player.Char_sally_shotlist[x]["led"]
            script_name = "sc_"+state
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=80, key="Char_sally_"+str(x), repeat=0, blend=True)


    def pophit(self, **kwargs):
        if self.machine.game.player.Char_sally_running == 1:    	
            #pop bumper hit, increase spinner value?
            self.player.Char_sally_pops += 1
            self.log.info("Char_sally  - " + str(self.player.Char_sally_pops ) + " pops, spin inc at 10, 30")            
            if self.player.Char_sally_pops >= self.player.Char_sally_pop_upgrade_4:
                self.log.info("Char_sally  - " + str(self.player.Char_sally_pops ) + " pops, at max")                        
                self.player.Char_sally_spin_value = 5
                self.machine.events.post('popuppost_disable_up')                
            elif self.player.Char_sally_pops >= self.player.Char_sally_pop_upgrade_3:            
                self.log.info("Char_sally  - " + str(self.player.Char_sally_pops ) + " pops, next inc at 50")
                self.player.Char_sally_spin_value = 4            
            elif self.player.Char_sally_pops >= self.player.Char_sally_pop_upgrade_2:            
                self.log.info("Char_sally  - " + str(self.player.Char_sally_pops ) + " pops, next inc at 40")                        
                self.player.Char_sally_spin_value = 3            
            elif self.player.Char_sally_pops >= self.player.Char_sally_pop_upgrade_1:            
                self.log.info("Char_sally  - " + str(self.player.Char_sally_pops ) + " pops, next inc at 30")                        
                self.player.Char_sally_spin_value = 2            
            else:
                self.log.info("Char_sally  - " + str(self.player.Char_sally_pops ) + " pops, next inc at 20")            
                self.player.Char_sally_spin_value = 1


    def enable_flipper(self):
        self.machine.flippers['flipperUpR'].enable()
        

    def disable_flipper(self):
        self.machine.flippers['flipperUpR'].disable()


    def spin(self, **kwargs):
        if self.machine.game.player.Char_sally_running == 1:
            self.log.info( 'Char_Sally spin')
            self.spval  = self.player.Char_sally_spin_value 
            self.spval *= self.player.multiplier_shot_value_list[1] # 1X, 2X or 3X 
            self.player.Char_sally_spins_needed -= self.spval 
            self.score = 25000*self.player.multiplier_shot_value_list[1] 
            if self.player.Char_sally_spins_needed <= 0:
                self.player.Char_sally_spins_needed = 0
            self.player.score += self.score 
            self.log.info('Char_sally - spins -' + str(self.player.Char_sally_spins_needed))            

                
    def mode_stop(self, **kwargs):
        self.log.info( 'Char_Sally mode_stop')
        self.enable_flipper()
        self.reset_lights()
        self.machine.events.post('popuppost_disable_up')


