from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing


# Char_Qualify
# keep track of which char is qualified and start the modes when appropriate
#
# For Character Modes, each needs to first be qualified, then started. 
# Each character mode has its own qualifying and starting methods. 
# When a character mode is qualified, any shot which will start the mode will flash orange. 
# Only one character's modes can be qualified at a time, thus if you qualify one character's 
# mode then qualify another's, the one you qualified first will be disqualified and will 
# have to be requalified before you can start it. The exception to this is Lock, Shock and 
# Barrel as they have a special bank of targets and bathtub for locking balls, so they don't 
# override the other characters. (However, you can only have one Character Mode running at 
# a time, so if you start say, "What's This?" Frenzy, the LSB multiball cannot be started 
# until the frenzy ends. You CAN however combine "What's This?" Frenzy with a 
# multiball from the Hinterlands or Oogie Boogie.)
#
#   Character Mode               Qualifying Method                                 Starting Method
# "What's This?" Frenzy       Spell JACK                                        Hinterlands (Overrides starting a Door Mode)
# "Where's Jack?"             Spell JACK (Some Character Modes not Complete)    Graveyard, Soup or Mayor
# "The Scientific Method"     Spell JACK (All other Character Modes Complete)   Graveyard, Soup or Mayor
# "Sally's Stitches"          Get 100 spins on the spinner                      Graveyard, Soup or Mayor
# "A Marked Improvement"      Shoot Doctor Finklestein                          Graveyard, Soup or Mayor
# "I Can't Make Decisions!"   Shoot the Mayor                                   Mayor (Yes, you shoot once to qualify, again to start)
# "Go Fetch!"                 Knock down the Gravestone                         Zero Kickback
# "Kidnap the Sandi-Claws"    Lock, Shock and Barrel Targets                    Bathtub Lock
#
# Character modes are tracked on the display as opposed to on the playfield. 
# Each character mode you complete shows up as a small head symbol of that character
# under the scores. Jack gets two heads since you have to complete two different 
# Jack modes (but not all three as you can only play one of "Where's Jack?" and "The
# Scientific Method"). Once a mode is complete it cannot be qualified again until 
# you've completed all the other Character modes and play the "Deliver the Presents"
# Wizard Mode.
#
# "Kidnap the Sandi-Claws" is an exception to this as it simply gets more difficult 
# to qualify and lock balls with each completion and is meant to be a multiball you can
# reliably go for without understanding the rest of the rules. The first time, you only 
# have to complete the LSB standup targets once to enable all three bathtub locks.
# The second time and onwards you have to complete the LSB standups three times, once 
# for each ball you wish to lock.

class Char_Qualify(Mode):

    def mode_init(self):
        self.log.info('Char_Qualify mode_init')

    def mode_start(self, **kwargs):
        self.vuk_fired = 0
        self.log.info('Char_Qualify mode_start')
        self.delay = DelayManager()
        if self.player.Char_Qualify_mode_started == 0:
            self.player.graves = 0
            #once per game only
            self.player.Char_Qualify_mode_started = 1
            self.player.Char_qualified = "none"  #char mode currently qualified
            # char state 
            # 0 = nothing, 
            # 1 = char qualified, 
            # 2 = char running, 
            # 3 = all completed (wizard ready)
            # 4 - wizard running
            # 5 - wizard completed
            self.player.Char_What_state = 0
            self.player.Char_Where_state = 0
            self.player.Char_Science_state = 0
            self.player.Char_Sally_state = 0
            self.player.Char_Doctor_state = 0
            self.player.Char_Mayor_state = 0
            self.player.Char_Zero_state = 0
            self.player.Char_LSB_state = 0
            self.player.Char_Wizard_state = 0
            self.player_mayor_spin = 1
        self.player.Char_state = 0  
        self.balls_in_subway = 0
        self.add_mode_event_handler("jack_spelled", self.jack_qualified)
        self.add_mode_event_handler("sally_spin_qualify", self.sally_qualified)
        self.add_mode_event_handler("sw_doctor", self.doctor_qualified)
        self.add_mode_event_handler("major_0_singlestep_unlit_hit", self.mayor)
        self.add_mode_event_handler("major_6_singlestep_unlit_hit", self.zero_qualified)
        self.add_mode_event_handler("LSB_bathtub_ready", self.LSB_qualified)
        self.add_mode_event_handler("sw_hrampgate", self.hinterlands)
        self.add_mode_event_handler("sw_saucer", self.saucer)
        self.add_mode_event_handler("mystery_done_with_ball", self.saucer)        
        self.add_mode_event_handler("taste_the_soup_singlestep_unlit_hit", self.soup)
        self.add_mode_event_handler("sw_zero", self.zero)
        self.add_mode_event_handler("LSB_ball_3_locked", self.LSB)
        self.add_mode_event_handler("sw_subwayoogie", self.subway_add_ball)
        self.add_mode_event_handler("sw_subwaytrees", self.subway_add_ball)  
        self.add_mode_event_handler("Char_mode_stopped", self.char_mode_stopped)  
        self.add_mode_event_handler("Char_is_qualified", self.set_lights)  
        self.add_mode_event_handler("balldevice_soupvuk_ball_eject_attempt", self.soup_ejected)          
        self.machine.game.player.Char_led_list = [
             {"char":"jack", "led":"rgb_jack_circle", "state":"off"}
            ,{"char":"sally", "led":"rgb_sally_circle", "state":"off"}
            ,{"char":"doctor", "led":"rgb_doctor_rect", "state":"off"}
            ,{"char":"mayor", "led":"rgb_mayor_circle", "state":"off"}
            ,{"char":"zero", "led":"rgb_zero_circle", "state":"off"}
            ,{"char":"lsb", "led":"rgb_bathtub_rect", "state":"off"}
            ,{"char":"wizard", "led":"rgb_charwiz_rect", "state":"off"}
            ]
        self.reset_states()
        self.machine.events.post("Char_LSB_start")            
        
    def reset_lights(self):
        for x in range(0, 7):
            self.machine.light_controller.stop_script(key="Char_qualify_"+str(x))


    def set_lights(self, value, **kwargs):
        for x in range(0, 7):
            self.machine.light_controller.stop_script(key="Char_qualify_"+str(x))
            self.machine.game.player.Char_led_list[x]["state"] = "off"

        if self.player.Char_What_state > 1:
            self.machine.game.player.Char_led_list[0]["state"] = "What_solid"
        else:
           if value == "What":            
                self.machine.game.player.Char_led_list[0]["state"] = "What"            

        if self.player.Char_Where_state > 1:
            self.machine.game.player.Char_led_list[0]["state"] = "Where_solid"
        else:
            if value == "Where":            
                self.machine.game.player.Char_led_list[0]["state"] = "Where"            

        if self.player.Char_Science_state > 1:
            self.machine.game.player.Char_led_list[0]["state"] = "Science_solid"
        else:
            if value == "Science":
                self.machine.game.player.Char_led_list[0]["state"] = "Science" 

        if value == "Jack":
                self.machine.game.player.Char_led_list[0]["state"] = "Science"

        if self.player.Char_Sally_state > 1:
            self.machine.game.player.Char_led_list[1]["state"] = "Sally_solid"
        else:
            if value == "Sally":
                self.machine.game.player.Char_led_list[1]["state"] = "Sally"
    
        if self.player.Char_Doctor_state > 1:
            self.machine.game.player.Char_led_list[2]["state"] = "Doctor_solid"
        else:
            if value == "Doctor":        
                self.machine.game.player.Char_led_list[2]["state"] = "Doctor"            

        if self.player.Char_Mayor_state > 1:
            self.machine.game.player.Char_led_list[3]["state"] = "Mayor_solid"
        else:
            if value == "Mayor":
                self.machine.game.player.Char_led_list[3]["state"] = "Mayor"
    
        if self.player.Char_Zero_state > 1:
            self.machine.game.player.Char_led_list[4]["state"] = "Zero_solid"
        else:
            if value == "Zero":
                self.machine.game.player.Char_led_list[4]["state"] = "Zero"

        if self.player.Char_LSB_state > 1:
            self.machine.game.player.Char_led_list[5]["state"] = "LSB_solid"
        else:
            if value == "LSB":
                self.machine.game.player.Char_led_list[5]["state"] = "LSB"
    
        if self.player.Char_Wizard_state > 1:
            self.machine.game.player.Char_led_list[6]["state"] = "Wizard_solid"
        else:
            if value == "Wizard":
                self.machine.game.player.Char_led_list[6]["state"] = "Wizard"
                
        for x in range(0, 7):
            state = self.machine.game.player.Char_led_list[x]["state"]
            led = self.machine.game.player.Char_led_list[x]["led"]
            script_name = "sc_char_"+state
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=160, key="Char_qualify_"+str(x), blend=True)

        
    def reset_states(self):
        if self.player.Char_What_state == 1:
            self.player.Char_What_state = 0            
        if self.player.Char_Where_state == 1:
            self.player.Char_Where_state = 0
        if self.player.Char_Science_state == 1:
            self.player.Char_Science_state = 0            
        if self.player.Char_Sally_state == 1:
            self.player.Char_Sally_state = 0
        if self.player.Char_Doctor_state == 1:
            self.player.Char_Doctor_state = 0
        if self.player.Char_Mayor_state == 1:
            self.player.Char_Mayor_state = 0
        if self.player.Char_Zero_state == 1:
            self.player.Char_Zero_state = 0
        if self.player.Char_LSB_state == 1:
            self.player.Char_LSB_state = 0
        if self.player.Char_Wizard_state == 1:
            self.player.Char_Wizard_state = 0
        self.stop_head_spin()            


    def show_status(self):
        self.log.info('Char_Qualify - status')                  
        self.log.info('Char_Qualify - Char state: '+str(self.player.Char_state)) 
        self.log.info('Char_Qualify - Char Qualified: '+str(self.player.Char_qualified)) 
        self.log.info('Char_Qualify - What state: '+str(self.player.Char_What_state))        
        self.log.info('Char_Qualify - Where state: '+str(self.player.Char_Where_state))        
        self.log.info('Char_Qualify - Sally state: '+str(self.player.Char_Sally_state))        
        self.log.info('Char_Qualify - Science state: '+str(self.player.Char_Science_state))        
        self.log.info('Char_Qualify - LSB state: '+str(self.player.Char_LSB_state))        
        self.log.info('Char_Qualify - Zero state: '+str(self.player.Char_Zero_state))        
        self.log.info('Char_Qualify - Mayor state: '+str(self.player.Char_Mayor_state))        
        self.log.info('Char_Qualify - Doctor state: '+str(self.player.Char_Doctor_state))        
        self.log.info('Char_Qualify - Wizard state: '+str(self.player.Char_Wizard_state))        
                                                                

    def char_mode_stopped(self, char_mode=None, char_state=None, **kwargs):
        self.log.info('Char_Qualify - a mode stopped - complete? '+str(char_state))
        self.player.Char_state = 0
        #state can be "complete" or "incomplete"
        if char_state == "complete":
            state = 2 #completed
            self.machine.events.post("Char_is_completed", value=char_mode)
        else:
            state = 0 #back to ready
            self.machine.events.post("Char_is_ended", value=char_mode)            
        if char_mode == "What":
            self.player.Char_What_state = state
            self.machine.events.post("Char_what_stop")            
        if char_mode == "Where":
            self.player.Char_Where_state = state
            self.machine.events.post("Char_where_stop")
        if char_mode == "Science":
            self.player.Char_Science_state = state
            self.machine.events.post("Char_science_stop")            
        if char_mode == "Sally":
            self.player.Char_Sally_state = state
            self.machine.events.post("Char_sally_stop")
        if char_mode == "Doctor":
            self.player.Char_Doctor_state = state
            self.machine.events.post("Char_doctor_stop")            
        if char_mode == "Mayor":
            self.player.Char_Mayor_state = state
            self.machine.events.post("Char_mayor_stop")            
        if char_mode == "Zero":
            self.player.Char_Zero_state = state
            self.machine.events.post("Char_zero_stop")            
        if char_mode == "LSB":
            self.player.Char_LSB_state = state
            self.machine.events.post("Char_LSB_stop")            
        if char_mode == "Wizard":
            self.player.Char_Wizard_state = state
            self.machine.events.post("Char_wizard_stop")            
        allcomplete = 0
        if self.player.Char_Where_state == 2 or self.player.Char_Science_state == 2:
            if self.player.Char_What_state == 2:
                if self.player.Char_Sally_state == 2:
                    if self.player.Char_Doctor_state == 2:
                        if self.player.Char_Mayor_state == 2:
                            if self.player.Char_Zero_state == 2:
                                if self.player.Char_LSB_state == 2:
                                    allcomplete = 1
        if allcomplete == 1:
            if char_mode != "Wizard":
                self.player.Char_state = 3
                self.Wizard_qualified()
            else:
                #all modes and wizard complete - now what? TODO - make Char Wiz LED solid
                self.log.info('Char_Qualify - All modes and Wizard complete - wait for reset')
        self.set_lights(value=None)


    def subway_add_ball(self, **kwargs):
        self.log.info('Char_Qualify - ball in subway from Oogie or tree')
        self.balls_in_subway += 1

    def jack_qualified(self, **kwargs):
        if self.player.Char_state < 2:
            if self.player.Char_qualified != "Jack":                        
                self.log.info('Char_Qualify Jack Qualified')
                self.player.Char_qualified = "Jack"
                self.qualify_change()
                #leads to one of these: "What", "Where" or "Science"

    def sally_qualified(self, **kwargs):
        if self.player.Char_state < 2:
            self.log.info('Char_Qualify Sally Qualified')
            self.player.Char_qualified = "Sally"
            self.qualify_change()            

    def doctor_qualified(self, **kwargs):
        if self.player.Char_state < 2:
            if self.player.Char_Doctor_state == 0:
                if self.player.Char_qualified != "Doctor":
                    self.log.info('Char_Qualify Doctor Qualified')
                    self.player.Char_qualified = "Doctor"
                    self.qualify_change()

    def zero_qualified(self, **kwargs):
        self.player.graves +=1
        if self.player.Char_state < 2:
            if self.player.Char_Zero_state == 0:
                if self.player.Char_qualified != "Zero":
                    self.log.info('Char_Qualify Zero Qualified')
                    self.player.Char_qualified = "Zero"
                    self.machine.events.post("Char_zero_qualified")
                    self.qualify_change()

    def qualify_change(self):
        self.log.info('Char_Qualified changed')
        self.machine.events.post("Char_is_qualified", value=self.player.Char_qualified)            
        if self.player.Char_qualified == "Zero":
            self.enable_zero_diverter()
        else:
            self.disable_zero_diverter()
       
    def enable_zero_diverter(self):
        self.machine.events.post('zero_enable_diverter')
        self.machine.events.post('mayor_disable_diverter')

    def disable_zero_diverter(self):
        self.machine.events.post('zero_disable_diverter')
        self.machine.events.post('mayor_enable_diverter')
                    

    def LSB_qualified(self, **kwargs):
        if self.player.Char_state < 2:
            self.log.info('Char_Qualify LSB Qualified')        	
            self.player.Char_qualified = "LSB"
            self.qualify_change()            

    def Wizard_qualified(self, **kwargs):
        if self.player.Char_state == 3:
            self.log.info('Char_Qualify Wizard Qualified')
            self.player.Char_qualified = "Wizard"
            self.qualify_change()            

    def stop_head_spin(self):
        self.log.info('Char_Qualify - stop head spin')        
        self.machine.coils['mayordiverter'].sneaky_servo(servo=11, position=95)

    def mayor(self, **kwargs):
        self.log.info('Char_Qualify - Mayor hit')    
        if self.balls_in_subway == 0:
            if self.player_mayor_spin == 1:
                self.machine.events.post("mayor_spin_1")
                self.player_mayor_spin = 2
                self.machine.coils['mayordiverter'].sneaky_servo(servo=11, position=140)
                delaytime = Timing.string_to_ms('500ms')
                self.delay.add(name="stop_head_spin", ms=delaytime, callback=self.stop_head_spin)
            else:
                self.machine.events.post("mayor_spin_2")
                self.player_mayor_spin = 1
                self.machine.coils['mayordiverter'].sneaky_servo(servo=11, position=140)
                delaytime = Timing.string_to_ms('500ms')
                self.delay.add(name="stop_head_spin", ms=delaytime, callback=self.stop_head_spin)
            if self.player.Char_state < 2:
                # if nothing is running, try mayor, or the others
                if self.player.Char_qualified == "Mayor":
                    self.log.info('Char_Qualify - start mayor mode?')                    
                    self.mayor_try_start()
                else:
                    #see if any of Jack, Sally, or Doctor are qualified, then start them
                    self.try_start()
                #if no char mode was started
                if self.player.Char_state < 2:
                    # qualify the mayor, if not already run
                    if self.player.Char_Mayor_state == 0:
                        self.log.info('Char_Qualify - Mayor Qualified')
                        self.player.Char_qualified = "Mayor"
                        self.qualify_change()                  
        else:
            #ball came from oogie or trees, decrement subway count, eject it
            self.balls_in_subway -= 1
            self.log.info('Char_Qualify - ball in mayor, came from oogie')    



    def mayor_try_start(self):
        #Mayor is qualified
        if self.player.Char_qualified == "Mayor":
            if self.player.Char_Mayor_state < 2:
                self.player.Char_Mayor_state = 1
                self.player.Char_state = 2
                self.machine.events.post("Char_mayor_start")


    def saucer(self, **kwargs):
        # if ball is in saucer collecting mystery
        # wait for event callback when mystery is done
        if self.player.mystery_ball_in_saucer == 0:
            self.try_start()
            delaytime = Timing.string_to_ms('3s')
            self.delay.add(name="delayed_saucer_eject", ms=delaytime, callback=self.eject_saucer_ball)
        else:
            self.log.info( 'ball is busy with mystery, waiting for callback' )

    def eject_saucer_ball(self):
        self.machine.coils['jackkickout'].pulse()                
        

    def soup(self, **kwargs):
        self.try_start()
        self.log.info('Char_Qualify - in the soup')
        #set a 2s timer, if we haven't ejected from VUK, then pulse it.
        self.vuk_fired = 0            
        delaytime = Timing.string_to_ms('2000ms')
        self.delay.add(name="ball_stuck_in_VUK", ms=delaytime, callback=self.soup_eject)

    def soup_eject(self, **kwargs):
        if self.vuk_fired == 0:
            self.log.info('Char_Qualify - stuck in the soup, eject')
            self.machine.coils['soupVUK'].pulse()

    def soup_ejected(self, **kwargs):
        self.vuk_fired = 1


    def try_start(self):
        # if nothing is running
        if self.player.Char_state < 2:
            #if jack is qualified
            if self.player.Char_qualified == "Jack":
                #if all other chars have been played, then play Scientific Method
                #else play Where's Jack
                if (self.player.Char_What_state > 0
                  and self.player.Char_Sally_state > 0
                  and self.player.Char_Doctor_state > 0
                  and self.player.Char_Mayor_state > 0
                  and self.player.Char_Zero_state > 0
                  and self.player.Char_LSB_state > 0):
                    if self.player.Char_Science_state == 0:
                        self.player.Char_qualified = "Science"
                        self.player.Char_Science_state = 1
                        self.player.Char_state = 2
                        self.machine.events.post("Char_science_start")
                else: 
                    #if Where's Jack hasn't been played, start it
                    if self.player.Char_Where_state < 2:
                        self.player.Char_qualified = "Where"
                        self.player.Char_Where_state = 1
                        self.player.Char_state = 2
                        self.machine.events.post("Char_where_start")
            #if Sally is qualified
            elif self.player.Char_qualified == "Sally":
                if self.player.Char_Sally_state < 2:
                    self.player.Char_Sally_state = 1
                    self.player.Char_state = 2
                    self.machine.events.post("Char_sally_start")
            #if Doctor is qualified
            elif self.player.Char_qualified == "Doctor":
                if self.player.Char_Doctor_state < 2:
                    self.player.Char_Doctor_state = 1
                    self.player.Char_state = 2
                    self.machine.events.post("Char_doctor_start")
        elif self.player.Char_state == 3:
            self.player.Char_Wizard_state = 1
            self.player.Char_state = 4
            self.machine.events.post("Char_wizard_start")
       

    def hinterlands(self, **kwargs):
        # if nothing is running
        if self.player.Char_state < 2:
            #if jack is qualified
            if self.player.Char_qualified == "Jack":
                #if What's This Frenzy hasn't been played, start it
                if self.player.Char_What_state == 0:
                    self.player.Char_qualified = "What"
                    self.player.Char_What_state = 1
                    self.player.Char_state = 2
                    self.machine.events.post("Char_what_start")
                    self.log.info('Char - What - start posted')

    def zero(self, **kwargs):
        self.show_status()
        # if nothing is running
        if self.player.Char_state < 2:
            #if Zero is qualified
            if self.player.Char_qualified == "Zero":
                #if Zero Fetch hasn't been played, start it
                if self.player.Char_Zero_state < 2:
                    self.player.Char_qualified = "Zero"
                    self.player.Char_Zero_state = 1
                    self.player.Char_state = 2
                    self.machine.events.post("Char_zero_start")
                    self.disable_zero_diverter()

    def LSB(self, **kwargs):
        # nothing should be running, but check for debug
        if self.player.Char_state < 2:
            #if LSB is qualified
            if self.player.Char_qualified == "LSB":
                if self.player.Char_LSB_state < 2:
                    self.player.Char_qualified = "LSB"
                    self.player.Char_LSB_state = 1
                    self.player.Char_state = 2
                    self.machine.events.post("Char_LSB_start")
        else:
            self.log.info('3rd ball locked in tub, but already running another char mode!')
            


    def mode_stop(self, **kwargs):
        #if a mode was running, stop it
        
        self.log.info('Char_Qualify mode_stop')
        self.reset_lights()
