from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Character Mode - "I Can't Make Decisions!"                                                                                                                           Page 19
# 
# Brief Description
# A travelling shot is scrolling across all the major shots really fast. 
# It's worth a ton of points to hit, but completely comes down to luck because 
# of how fast it moves.
# Instead, you can shoot the mayor to temporarily lock the shot in place so that 
# it's not worth quite as much, but can be made at all so the mode can be completed.
# 
# Scenario
# The mayor of Halloween Town needs help to plan the next Halloween, but 
# Jack's not around to help out and the mayor can't make decisions on his own!
# 
# Details
# When the mode starts, the Mayor toy flips to show that he's unhappy and one 
# of the major shots will light up... but the shot travels to other major shots extremely
# quickly, changing about 10 times a second. This is nearly impossible to time, 
# but the shot CAN be made while it's still travelling and is worth a lot more points 
# if made this way. However, to complete the mode, you only have to make the travelling shot 
# once, thus the best thing to do is to shoot the mayor. This will flip the mayor
# around to his happy side and will stop the lit shot from travelling around. 
# It stays stopped for about 10 seconds and will begin to flash if it's getting ready 
# to start moving again. Making the shot ends the mode, plain and simple.
# 
# Scoring
# Major Shot Cleared (Travelling)             10,000,000
# Major Shot Cleared (Halted)                 2,500,000
# 
# Lighting
# When the major shot is travelling it lights both the triangle and circle it's on red. 
# When it's halted, it turns yellow. The Mayor shot shows a flashing blue triangle when
# the major shot is travelling and goes out once the major shot is halted.
# 
# 
# Difficulty Adjustments
# Very Easy        40 Second Time Limit
# Easy             35 Second Time Limit
# Normal           30 Second Time Limit
# Hard             25 Second Time Limit
# Very Hard        20 Second Time Limit

class Char_Mayor(Mode):

    def mode_init(self):
        print 'Char_Mayor mode_init'

    def mode_start(self, **kwargs):
        print 'Char_Mayor mode_start'
        self.delay = DelayManager()
        if self.player.Char_mayor_started == 0:
            #once per game only
            self.player.Char_mayor_started = 1
            self.player.Char_mayor_shot_state = 0
            self.player.Char_mayor_base_ticks = 60 #60 = 30 seconds
            self.player.Char_mayor_shot_made = 0
            self.player.Char_mayor_shot_number = 0
            self.player.Char_mayor_score = 10000000
        self.player.Char_mayor_state = 0  
        # 0 - ready
        # 1 - starting
        # 2 - roaming
        # 3 - frozen
        # 4 - unfreezing
        # 5 - completed          
        self.ticks = self.player.Char_mayor_base_ticks
        self.player.Char_mayor_shotlist = [
            {"led":"rgb_mayor_arrow", "state":"off"}
            ,{"led":"rgb_lorbit_arrow", "state":"off"}
            ,{"led":"rgb_lramp_arrow", "state":"off"}
            ,{"led":"rgb_leftloop_arrow", "state":"off"}
            ,{"led":"rgb_oogie_cw_arrow", "state":"off"}
            ,{"led":"rgb_oogie_ccw_arrow", "state":"off"}
            ,{"led":"rgb_grave_arrow", "state":"off"}
            ,{"led":"rgb_rramp_arrow", "state":"off"}
            ,{"led":"rgb_rorbit_arrow", "state":"off"}
            ,{"led":"rgb_soup_arrow", "state":"off"}
            ]
        self.add_mode_event_handler("major_0_singlestep_unlit_hit", self.mayor_hit)
        self.add_mode_event_handler("major_1_singlestep_unlit_hit", self.major_1)
        self.add_mode_event_handler("major_2_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_2a_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_3_singlestep_unlit_hit", self.major_3)
        self.add_mode_event_handler("major_4_singlestep_unlit_hit", self.major_4)
        self.add_mode_event_handler("major_5_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_5a_singlestep_unlit_hit", self.major_5)
        self.add_mode_event_handler("major_6_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_6a_singlestep_unlit_hit", self.major_6)
        self.add_mode_event_handler("major_7_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_7a_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_8_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_8a_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_9_singlestep_unlit_hit", self.major_9)
        self.Char_mayor_start()

    def Char_mayor_start(self):
        print "Char_mayor_start"
        if (self.player.Char_mayor_state == 0):
            self.player.Char_mayor_state = 1
            self.ticks = self.player.Char_mayor_base_ticks
            self.player.Char_mayor_shot_made = 0
            self.set_shots()
            self.machine.events.post("Char_mayor_music_start")
            self.machine.events.post("say_i_cant")
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="Char_mayor_ticker", ms=delaytime, callback=self.ticker)
            delaytime = Timing.string_to_ms('200ms')
            self.delay.add(name="Char_mayor_start_shot_cycler", ms=delaytime, callback=self.start_cycle_shots)

    def ticker(self):
        print "Char_mayor - 500ms tick"
        self.timeleft = int(self.ticks/2)
        if self.player.Char_mayor_state == 2:
            self.machine.events.post("Char_mayor_countdown_roaming", value=self.timeleft)
        else:
            self.machine.events.post("Char_mayor_countdown_frozen", value=self.timeleft)
        self.ticks -= 1;
        if self.ticks > 30:
            self.machine.events.post("set_gi_col", red=80, green=0, blue=160)
        else:
            if self.ticks%2 == 0:        
                self.machine.events.post("set_gi_col", red=80, green=0, blue=10+self.ticks*5)         
            else:
                self.machine.events.post("set_gi_col", red=80, green=0, blue=160)
        if self.ticks <= 0:
            self.Char_mayor_stop()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="Char_mayor_ticker", ms=delaytime, callback=self.ticker)

    def Char_mayor_stop(self):
        if self.player.Char_mayor_state > 0:
            self.log.info('Char_mayor - stopping. remove delays')                	                	
            self.delay.remove("Char_mayor_shot_cycler")
            self.delay.remove("Char_mayor_start_shot_cycler")
            self.delay.remove("Char_mayor_ticker")
            self.delay.remove("Char_mayor_shot_unfreeze")
            self.machine.events.post('Char_mayor_music_stop')
            self.log.info("Char_mayor over")
            if self.player.Char_mayor_shot_made == 1:
                self.machine.events.post('Char_mode_stopped', char_state="complete", char_mode="Mayor")
                self.player.Char_mayor_state = 3 #completed
            else:
                self.machine.events.post('Char_mode_stopped', char_state="incomplete", char_mode="Mayor")
                self.player.Char_mayor_state = 0 #ready to start again
            self.reset_shots()

    def set_shots(self):
        for x in range(0, 10):
            self.player.Char_mayor_shotlist[x]["state"] = "off"
        self.player.Char_mayor_shotlist[0]["state"] = "blue_flash"
        self.player.Char_mayor_shot_number = random.randint(1,9)
        self.player.Char_mayor_shotlist[self.player.Char_mayor_shot_number]["state"] = "red_flash"
        self.set_shot_lights()

    def start_cycle_shots(self):
        self.player.Char_mayor_state = 2
        self.player.Char_mayor_score = 10000000
        self.cycle_shots()

    def cycle_shots(self):
        self.log.info('Char_mayor - cycle_shots')
        if self.player.Char_mayor_state == 2:
            for x in range(1, 10):
                self.player.Char_mayor_shotlist[x]["state"] = "off"
            self.player.Char_mayor_shot_number += 1
            if self.player.Char_mayor_shot_number > 9:
                self.player.Char_mayor_shot_number = 1
            self.player.Char_mayor_shotlist[self.player.Char_mayor_shot_number]["state"] = "red_flash"
            self.player.Char_mayor_shotlist[0]["state"] = "blue_flash"
            if self.ticks > 2:
                delaytime = Timing.string_to_ms('200ms')
                self.delay.add(name="Char_mayor_shot_cycler", ms=delaytime, callback=self.cycle_shots)
                self.set_shot_lights()
                self.log.info('Char_mayor - cycle_shots 200ms delay added')
                

    def freeze_shot(self):
        self.log.info("Freeze shot")
        if self.player.Char_mayor_state == 2:
            self.player.Char_mayor_state = 3
            self.delay.remove("Char_mayor_shot_cycler")
            self.machine.events.post("say_im_only_elected")
            self.player.Char_mayor_score = 2500000
            for x in range(0, 10):
                self.player.Char_mayor_shotlist[x]["state"] = "off"
            self.player.Char_mayor_shotlist[self.player.Char_mayor_shot_number]["state"] = "cyan_flash"
            self.set_shot_lights()
            if self.ticks > 12:
                delaytime = Timing.string_to_ms('6s')
                self.delay.add(name="Char_mayor_shot_unfreeze", ms=delaytime, callback=self.unfreeze_shot)


    def unfreeze_shot(self):
        if self.player.Char_mayor_state == 3:
            self.player.Char_mayor_state = 4
            for x in range(1, 10):
                self.player.Char_mayor_shotlist[x]["state"] = "off"
            self.player.Char_mayor_shotlist[self.player.Char_mayor_shot_number]["state"] = "fast_cyan_flash"
            delaytime = Timing.string_to_ms('3s')
            self.delay.add(name="Char_mayor_start_shot_cycler", ms=delaytime, callback=self.start_cycle_shots)
            self.set_shot_lights()


    def set_shot_lights(self):
        for x in range(0, 10):
            self.machine.light_controller.stop_script(key="Char_mayor_"+str(x))
        for x in range(0, 10):
            state = self.player.Char_mayor_shotlist[x]["state"]
            led = self.player.Char_mayor_shotlist[x]["led"]
            script_name = "sc_"+state
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=160, key="Char_mayor_"+str(x), blend=True)


    def major_1(self, **kwargs):
        self.handle_shot(1)
    def major_2(self, **kwargs):
        self.handle_shot(2)
    def major_3(self, **kwargs):
        self.handle_shot(3)
    def major_4(self, **kwargs):
        self.handle_shot(4)
    def major_5(self, **kwargs):
        self.handle_shot(5)
    def major_6(self, **kwargs):
        self.handle_shot(6)
    def major_7(self, **kwargs):
        self.handle_shot(7)
    def major_8(self, **kwargs):
        self.handle_shot(8)
    def major_9(self, **kwargs):
        self.handle_shot(9)


    def handle_shot(self, shot):
        if self.player.Char_mayor_state > 0 and self.player.Char_mayor_state < 5:
            self.score = 0
            state = self.player.Char_mayor_shotlist[shot]["state"]
            self.log.info("Char_mayor - shot "+str(shot) + " hit, state = "+state)        	
            #not lit, skip it
            if state != "off":
                self.player.Char_mayor_shot_made = 1
                self.player.Char_mayor_state = 5
                if self.player.Char_mayor_shot_roaming == 0:
                    self.log.info('Char_mayor - got the still shot')                	                	
                    self.score = 2500000
                    self.machine.events.post("say_jackpot") 
                else:
                    self.log.info('Char_mayor - got the roaming shot!')                	
                    self.score = 10000000
                    self.machine.events.post("say_super_jackpot") 
                self.score *= self.player.multiplier_shot_value_list[shot] # 1X, 2X or 3X 
                self.player.score += self.score
                self.Char_mayor_stop()
            else:
                self.log.info('Char_mayor - missed shot')


    def mayor_hit(self, **kwargs):
        self.log.info('Char_mayor hit '+str(self.player.Char_mayor_state))
        if self.player.Char_mayor_state == 2:
            self.log.info('Char_mayor hit')
            self.freeze_shot()
        else:
            self.machine.events.post("mayor_shot_refrozen") 


    def reset_shots(self):
        for x in range(0, 10):
            self.player.Char_mayor_shotlist[x]["state"] = "off"
        self.set_shot_lights()


    def mode_stop(self, **kwargs):
        print 'Char_mayor_mode_stop'
        self.Char_mayor_stop()
        self.reset_shots()
