from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

#Char_Doc
# A Marked Improvement
# Brief Description
# 5 major shots are lit. Specifically: Left Ramp, Right Ramp, Left Orbit, 
# Right Orbit, and Left Pops Orbit. 
# You must make all 5 shots within the time limit to complete the mode.
# 
# Scenario
# Doctor Finklestein is trying to come up with a design for a new assistant, 
# but he needs to find all of his build plans.
# 
# Details
# When the mode begins, 5 major shots are lit: Left Ramp, Right Ramp, 
# Left Orbit, Right Orbit, and Left Pops Orbit. 
# Each one is worth an increasing number of points.
# Clearing all 5 completes the mode. There's a 30 second time limit to 
# complete the mode within.
# 
# Scoring
# First Major Shot Cleared                    200,000
# Increment for Each Additional Shot          200,000
# 
# Lighting
# The shots you need to make will have flashing yellow triangles.
# 
# Difficulty Adjustments
# Very Easy        40 Second Time Limit
# Easy             35 Second Time Limit
# Normal           30 Second Time Limit
# Hard             25 Second Time Limit
# Very Hard        20 Second Time Limit

class Char_Doc(Mode):

    def mode_init(self):
        print 'Char_Doc mode_init'

    def mode_start(self, **kwargs):
        print 'Char_Doc mode_start'
        self.delay = DelayManager()
        if self.player.Char_doctor_started == 0:
            #once per game only
            self.player.Char_doctor_started = 1
            self.player.Char_doctor_running = 0
            self.player.Char_doctor_base_ticks = 90 #60 = 30 seconds
            self.player.Char_doctor_shots_made = 0
            self.player.char_doctor_score = 0
        self.player.Char_doctor_ticks = self.player.Char_doctor_base_ticks
        self.machine.game.player.Char_doctor_shotlist = [
             {"led":"rgb_lorbit_arrow", "state":"off", "mult":1}
            ,{"led":"rgb_lramp_arrow", "state":"off", "mult":2}
            ,{"led":"rgb_leftloop_arrow", "state":"off", "mult":3}
            ,{"led":"rgb_rramp_arrow", "state":"off", "mult":7}
            ,{"led":"rgb_rorbit_arrow", "state":"off", "mult":8}
            ]
        self.add_mode_event_handler('sw_doctor', self.doctor_hit)
        self.add_mode_event_handler("major_1_singlestep_unlit_hit", self.major_1)
        self.add_mode_event_handler("major_2_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_2a_singlestep_unlit_hit", self.major_2)
        self.add_mode_event_handler("major_3_singlestep_unlit_hit", self.major_3)
        self.add_mode_event_handler("major_7_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_7a_singlestep_unlit_hit", self.major_7)
        self.add_mode_event_handler("major_8_singlestep_unlit_hit", self.major_8)
        self.add_mode_event_handler("major_8a_singlestep_unlit_hit", self.major_8)
        self.Char_doctor_start()


    def Char_doctor_start(self):
        print "Char_doctor_start"
        if (self.player.Char_doctor_running == 0):
            self.player.Char_doctor_ticks = self.player.Char_doctor_base_ticks
            self.player.Char_doctor_shots_made = 0
            self.set_shots()
            self.player.Char_doctor_running = 1
            self.machine.events.post("Char_doctor_music_start")
            self.machine.events.post("say_improvement")
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="Char_doctor_ticker", ms=delaytime, callback=self.ticker)

    def ticker(self):
        print "Char_doc - 500ms tick"
        self.player.Char_doctor_timeleft = int(self.player.Char_doctor_ticks/2)
        self.machine.events.post("Char_doctor_countdown")
        self.player.Char_doctor_ticks -= 1;
        if self.player.Char_doctor_ticks > 30:
            self.machine.events.post("set_gi_col", red=0, green=80, blue=160)
        else:
            if self.player.Char_doctor_ticks%2 == 0:
                self.machine.events.post("set_gi_col", red=0, green=80, blue=10+self.player.Char_doctor_ticks*5)
            else:
                self.machine.events.post("set_gi_col", red=0, green=0, blue=160)
        if self.player.Char_doctor_ticks <= 0:
            self.Char_doctor_stop()
        else:
            delaytime = Timing.string_to_ms('500ms')
            self.delay.add(name="Char_doctor_ticker", ms=delaytime, callback=self.ticker)

    def Char_doctor_stop(self):
        if self.machine.game.player.Char_doctor_running == 1:
            self.delay.remove("Char_doctor_ticker")
            self.machine.events.post('Char_doctor_music_stop')
            print "Char_doc over"
            if self.player.Char_doctor_shots_made == 5:
                self.machine.events.post('Char_mode_stopped', char_state="complete", char_mode="Doctor")
                self.machine.game.player.Char_doctor_running = 2 #completed
            else:
                self.machine.events.post('Char_mode_stopped', char_state="incomplete", char_mode="Doctor")
                self.machine.game.player.Char_doctor_running = 0 #ready to start again
            self.reset_shots()

    def set_shots(self):
        for x in range(0, 5):
            self.machine.game.player.Char_doctor_shotlist[x]["state"] = "doc_yellow_flash"
        self.set_shot_lights()

    def set_shot_lights(self):
        for x in range(0, 5):
            self.machine.light_controller.stop_script(key="Char_doctor_"+str(x))
        for x in range(0, 5):
            state = self.machine.game.player.Char_doctor_shotlist[x]["state"]
            led = self.machine.game.player.Char_doctor_shotlist[x]["led"]
            script_name = "sc_"+state
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=160, key="Char_doctor_"+str(x), blend=True)


    def major_1(self, **kwargs):
        self.handle_shot(0)
    def major_2(self, **kwargs):
        self.handle_shot(1)
    def major_3(self, **kwargs):
        self.handle_shot(2)
    def major_7(self, **kwargs):
        self.handle_shot(3)
    def major_8(self, **kwargs):
        self.handle_shot(4)


    def handle_shot(self, shot):
        if self.machine.game.player.Char_doctor_running == 1:
            self.log.info('Char_doc shot ' +str(shot))
            self.score = 0
            state = self.machine.game.player.Char_doctor_shotlist[shot]["state"]
            #not lit, skip it
            if state != "off":
                self.machine.events.post('say_doc_line')
                self.player.Char_doctor_shots_made += 1
                self.score = 200000 * self.player.Char_doctor_shots_made
                mult_index = self.machine.game.player.Char_doctor_shotlist[shot]["mult"] #1,2,3,7,8
                self.score *= self.player.multiplier_shot_value_list[mult_index] # 1X, 2X or 3X 
                self.player.score += self.score
                self.player.char_doctor_score += self.score
                self.machine.game.player.Char_doctor_shotlist[shot]["state"] = "off"
                self.set_shot_lights()
            if self.player.Char_doctor_shots_made == 5:
                self.Char_doctor_stop()


    def doctor_hit(self, **kwargs):
        if self.machine.game.player.Char_doctor_running == 1:
            self.log.info('Char_doc hit')


    def reset_shots(self):
        for x in range(0, 5):
            self.machine.game.player.Char_doctor_shotlist[x]["state"] = "off"
        self.set_shot_lights()


    def mode_stop(self, **kwargs):
        print 'Char_doctor_mode_stop'
        self.Char_doctor_stop()
        self.reset_shots()
