from mpf.system.mode import Mode
from mpf.system.tasks import DelayManager
from mpf.system.timing import Timing
import random

# Add-a-Ball is slightly different. When in any multiball, the mystery target will be 
# solid green. 
# Hit it once to make it start flashing, then again to clear it and light the
# graveyard shot with a green triangle. Hitting the graveyard now will start to 
# display the mystery award sequence, but a giant pinball will fall on the bag of toys,
# pushing the sleigh and Santa out of the display area and showing "Add-a-Ball" text. 
# Afterwards, the mystery shot no longer functions for the duration of the multiball.
# Also, if you start a multiball with the mystery award lit, the graveyard 
# shot immediately lights for an add-a-ball.

class Add_A_Ball(Mode):

    def mode_init(self):
        print 'Add_A_Ball mode_init'

    def mode_start(self, **kwargs):
        print 'Add_A_Ball mode_start'
        self.delay = DelayManager()
        self.player.add_a_ball_state = 0

        self.add_mode_event_handler('sw_mystery', self.mystery_hit)
        self.add_mode_event_handler('sw_grave', self.gravestone_hit)        
        self.add_mode_event_handler('sw_saucer', self.jack_saucer_hit) 
        self.add_mode_event_handler('add_a_ball_start', self.reset) 
        self.light_mystery()
        #TODO - or if grave was already lit, then self.light_grave()
        

    def reset(self, **kwargs):
        #if we got another MB started, relight mystery for add-a-ball
        if self.player.add_a_ball_state == 4:
            self.player.add_a_ball_state = 0
            self.light_mystery()


    def light_mystery(self, **kwargs):
        if self.player.add_a_ball_state == 0:
            self.player.add_a_ball_state = 1
            print "Add_A_Ball - MB started"
            #turn the mystery target green
            led = "rgb_mystery_rect"
            script_name = "sc_green_solid"
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=80, key="add_a_ball_mystery", blend=True)
            

    def mystery_hit(self, **kwargs):
        print 'Add_A_Ball - mystery hit'
        if self.player.add_a_ball_state == 1:
            self.player.add_a_ball_state = 2
            print "Add_A_Ball - Mystery hit"
            self.machine.light_controller.stop_script(key="add_a_ball_mystery")
            #turn the mystery target green flash
            led = "rgb_mystery_rect"
            script_name = "sc_green_flash"
            scp = self.machine.light_controller.registered_light_scripts[script_name]
            self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=60, key="add_a_ball_mystery", blend=True)
        elif self.player.add_a_ball_state == 2:
            self.player.add_a_ball_state = 3
            print "Add_A_Ball - Mystery hit 2nd time"
            self.machine.light_controller.stop_script(key="add_a_ball_mystery") 
            self.light_grave()
            

    def light_grave(self):          
        #light the grave target
        led = "rgb_grave_arrow"
        script_name = "sc_green_flash"
        scp = self.machine.light_controller.registered_light_scripts[script_name]
        self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=120, key="add_a_ball_jack", blend=True)
        

    def gravestone_hit(self, **kwargs):
        if self.player.add_a_ball_state == 3:
            print 'Add_A_Ball - gravestone hit'        
            self.award_ball()
            #no ball to eject

    def jack_saucer_hit(self, **kwargs):
        if self.player.add_a_ball_state == 3:
            print 'Add_A_Ball - jack saucer hit'
            self.award_ball()                
            delaytime = Timing.string_to_ms('3s')
            self.delay.add(name="delayed_saucer_eject", ms=delaytime, callback=self.eject_saucer_ball)

    def eject_saucer_ball(self):
        self.machine.coils['jackkickout'].pulse()                

            
    def award_ball(self):
        self.player.add_a_ball_state = 4
        self.machine.light_controller.stop_script(key="add_a_ball_jack")
        led = "rgb_grave_arrow"
        script_name = "sc_white_flash"
        scp = self.machine.light_controller.registered_light_scripts[script_name]
        self.machine.light_controller.run_script(leds=led, script=scp, priority=140, tocks_per_sec=80, key="add_a_ball_mystery", repeat=False, blend=True)
        bip = self.machine.game.balls_in_play 
        if bip < 6:
            self.machine.game.add_balls_in_play(1)
            self.machine.playfield.add_ball(1, player_controlled=False)
        else:
            print 'Add_A_Ball - 6 balls in play, TODO pts?'

    def mode_stop(self, **kwargs):
        print 'Add_A_Ball mode_stop'
        self.machine.light_controller.stop_script(key="add_a_ball_jack")
        self.machine.light_controller.stop_script(key="add_a_ball_mystery")
